/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.dynamic.sql.elements.v2;

import java.util.HashSet;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.config.GeneratedKey;
import org.mybatis.generator.runtime.dynamic.sql.elements.AbstractMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.MethodAndImports;
import org.mybatis.generator.runtime.dynamic.sql.elements.MethodParts;
import org.mybatis.generator.runtime.dynamic.sql.elements.v2.Utils;

public class BasicMultipleInsertMethodGenerator
extends AbstractMethodGenerator {
    private FullyQualifiedJavaType recordType;

    private BasicMultipleInsertMethodGenerator(Builder builder) {
        super(builder);
        this.recordType = builder.recordType;
    }

    @Override
    public MethodAndImports generateMethodAndImports() {
        if (!Utils.generateMultipleRowInsert(this.introspectedTable)) {
            return null;
        }
        GeneratedKey gk = this.introspectedTable.getGeneratedKey();
        if (gk == null) {
            return this.generateMethodWithoutGeneratedKeys();
        }
        return this.generateMethodWithGeneratedKeys(gk);
    }

    private MethodAndImports generateMethodWithoutGeneratedKeys() {
        HashSet<FullyQualifiedJavaType> imports = new HashSet<FullyQualifiedJavaType>();
        FullyQualifiedJavaType adapter = new FullyQualifiedJavaType("org.mybatis.dynamic.sql.util.SqlProviderAdapter");
        FullyQualifiedJavaType annotation = new FullyQualifiedJavaType("org.apache.ibatis.annotations.InsertProvider");
        imports.add(new FullyQualifiedJavaType("org.mybatis.dynamic.sql.insert.render.MultiRowInsertStatementProvider"));
        imports.add(adapter);
        imports.add(annotation);
        FullyQualifiedJavaType parameterType = new FullyQualifiedJavaType("org.mybatis.dynamic.sql.insert.render.MultiRowInsertStatementProvider");
        imports.add(this.recordType);
        parameterType.addTypeArgument(this.recordType);
        Method method = new Method("insertMultiple");
        method.setAbstract(true);
        method.setReturnType(FullyQualifiedJavaType.getIntInstance());
        method.addParameter(new Parameter(parameterType, "multipleInsertStatement"));
        this.context.getCommentGenerator().addGeneralMethodAnnotation(method, this.introspectedTable, imports);
        method.addAnnotation("@InsertProvider(type=SqlProviderAdapter.class, method=\"insertMultiple\")");
        MethodAndImports.Builder builder = MethodAndImports.withMethod(method).withImports(imports);
        return builder.build();
    }

    private MethodAndImports generateMethodWithGeneratedKeys(GeneratedKey gk) {
        HashSet<FullyQualifiedJavaType> imports = new HashSet<FullyQualifiedJavaType>();
        imports.add(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Insert"));
        imports.add(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Param"));
        Parameter parm1 = new Parameter(FullyQualifiedJavaType.getStringInstance(), "insertStatement");
        parm1.addAnnotation("@Param(\"insertStatement\")");
        FullyQualifiedJavaType recordListType = FullyQualifiedJavaType.getNewListInstance();
        recordListType.addTypeArgument(this.recordType);
        imports.add(recordListType);
        Parameter parm2 = new Parameter(recordListType, "records");
        parm2.addAnnotation("@Param(\"records\")");
        Method method = new Method("insertMultiple");
        method.setAbstract(true);
        method.setReturnType(FullyQualifiedJavaType.getIntInstance());
        method.addParameter(parm1);
        method.addParameter(parm2);
        this.context.getCommentGenerator().addGeneralMethodAnnotation(method, this.introspectedTable, imports);
        method.addAnnotation("@Insert({");
        method.addAnnotation("    \"${insertStatement}\"");
        method.addAnnotation("})");
        MethodAndImports.Builder builder = MethodAndImports.withMethod(method).withImports(imports);
        MethodParts methodParts = this.getGeneratedKeyAnnotation(gk);
        this.acceptParts(builder, method, methodParts);
        return builder.build();
    }

    private MethodParts getGeneratedKeyAnnotation(GeneratedKey gk) {
        MethodParts.Builder builder = new MethodParts.Builder();
        StringBuilder sb = new StringBuilder();
        this.introspectedTable.getColumn(gk.getColumn()).ifPresent(introspectedColumn -> {
            if (gk.isJdbcStandard()) {
                builder.withImport(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Options"));
                sb.append("@Options(useGeneratedKeys=true,keyProperty=\"records.");
                sb.append(introspectedColumn.getJavaProperty());
                sb.append("\")");
                builder.withAnnotation(sb.toString());
            }
        });
        return builder.build();
    }

    @Override
    public boolean callPlugins(Method method, Interface interfaze) {
        return this.context.getPlugins().clientBasicInsertMultipleMethodGenerated(method, interfaze, this.introspectedTable);
    }

    public static class Builder
    extends AbstractMethodGenerator.BaseBuilder<Builder, BasicMultipleInsertMethodGenerator> {
        private FullyQualifiedJavaType recordType;

        public Builder withRecordType(FullyQualifiedJavaType recordType) {
            this.recordType = recordType;
            return this;
        }

        @Override
        public Builder getThis() {
            return this;
        }

        @Override
        public BasicMultipleInsertMethodGenerator build() {
            return new BasicMultipleInsertMethodGenerator(this);
        }
    }
}

