/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.plugins;

import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;

public class CaseInsensitiveLikePlugin
extends PluginAdapter {
    @Override
    public boolean validate(List<String> warnings) {
        return true;
    }

    @Override
    public boolean modelExampleClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        topLevelClass.getInnerClasses().stream().filter(this::isGeneratedCriteria).findFirst().ifPresent(c -> this.addMethods(introspectedTable, (InnerClass)c));
        return true;
    }

    private boolean isGeneratedCriteria(InnerClass innerClass) {
        return "GeneratedCriteria".equals(innerClass.getType().getShortName());
    }

    private void addMethods(IntrospectedTable introspectedTable, InnerClass criteria) {
        introspectedTable.getNonBLOBColumns().stream().filter(this::isEligibleColumn).map(this::toMethod).forEach(criteria::addMethod);
    }

    private boolean isEligibleColumn(IntrospectedColumn introspectedColumn) {
        return introspectedColumn.isJdbcCharacterColumn() && introspectedColumn.isStringColumn();
    }

    private Method toMethod(IntrospectedColumn introspectedColumn) {
        StringBuilder sb = new StringBuilder();
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        sb.insert(0, "and");
        sb.append("LikeInsensitive");
        Method method = new Method(sb.toString());
        method.setVisibility(JavaVisibility.PUBLIC);
        method.addParameter(new Parameter(introspectedColumn.getFullyQualifiedJavaType(), "value"));
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        sb.setLength(0);
        sb.append("addCriterion(\"upper(");
        sb.append(MyBatis3FormattingUtilities.getAliasedActualColumnName(introspectedColumn));
        sb.append(") like\", value.toUpperCase(), \"");
        sb.append(introspectedColumn.getJavaProperty());
        sb.append("\");");
        method.addBodyLine(sb.toString());
        method.addBodyLine("return (Criteria) this;");
        return method;
    }
}

