/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.logging.slf4j;

import org.mybatis.generator.logging.Log;
import org.mybatis.generator.logging.slf4j.Slf4jLocationAwareLoggerImpl;
import org.mybatis.generator.logging.slf4j.Slf4jLoggerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jImpl
implements Log {
    private Log log;

    public Slf4jImpl(Class<?> clazz) {
        Logger logger = LoggerFactory.getLogger(clazz);
        if (logger instanceof LocationAwareLogger) {
            try {
                logger.getClass().getMethod("log", Marker.class, String.class, Integer.TYPE, String.class, Object[].class, Throwable.class);
                this.log = new Slf4jLocationAwareLoggerImpl((LocationAwareLogger)logger);
                return;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        this.log = new Slf4jLoggerImpl(logger);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public void error(String s, Throwable e) {
        this.log.error(s, e);
    }

    @Override
    public void error(String s) {
        this.log.error(s);
    }

    @Override
    public void debug(String s) {
        this.log.debug(s);
    }

    @Override
    public void warn(String s) {
        this.log.warn(s);
    }
}

