/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.internal.util;

import java.lang.reflect.Array;

public final class HashCodeUtil {
    public static final int SEED = 23;
    private static final int ODD_PRIME_NUMBER = 37;

    private HashCodeUtil() {
    }

    public static int hash(int seed, boolean b) {
        return HashCodeUtil.firstTerm(seed) + (b ? 1 : 0);
    }

    public static int hash(int seed, char c) {
        return HashCodeUtil.firstTerm(seed) + c;
    }

    public static int hash(int seed, int i) {
        return HashCodeUtil.firstTerm(seed) + i;
    }

    public static int hash(int seed, long l) {
        return HashCodeUtil.firstTerm(seed) + (int)(l ^ l >>> 32);
    }

    public static int hash(int seed, float f) {
        return HashCodeUtil.hash(seed, Float.floatToIntBits(f));
    }

    public static int hash(int seed, double d) {
        return HashCodeUtil.hash(seed, Double.doubleToLongBits(d));
    }

    public static int hash(int seed, Object o) {
        int result = seed;
        if (o == null) {
            result = HashCodeUtil.hash(result, 0);
        } else if (!HashCodeUtil.isArray(o)) {
            result = HashCodeUtil.hash(result, o.hashCode());
        } else {
            int length = Array.getLength(o);
            for (int idx = 0; idx < length; ++idx) {
                Object item = Array.get(o, idx);
                result = HashCodeUtil.hash(result, item);
            }
        }
        return result;
    }

    private static int firstTerm(int seed) {
        return 37 * seed;
    }

    private static boolean isArray(Object anObject) {
        return anObject.getClass().isArray();
    }
}

