/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mybatis.generator.api.GeneratedXmlFile;
import org.mybatis.generator.config.MergeConstants;
import org.mybatis.generator.exception.ShellException;
import org.mybatis.generator.internal.DomWriter;
import org.mybatis.generator.internal.util.messages.Messages;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlFileMergerJaxp {
    private XmlFileMergerJaxp() {
    }

    public static String getMergedSource(GeneratedXmlFile generatedXmlFile, File existingFile) throws ShellException {
        try {
            return XmlFileMergerJaxp.getMergedSource(new InputSource(new StringReader(generatedXmlFile.getFormattedContent())), new InputSource(new InputStreamReader((InputStream)new FileInputStream(existingFile), StandardCharsets.UTF_8)), existingFile.getName());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ShellException(Messages.getString("Warning.13", existingFile.getName()), e);
        }
    }

    public static String getMergedSource(InputSource newFile, InputSource existingFile, String existingFileName) throws IOException, SAXException, ParserConfigurationException, ShellException {
        Node node;
        int i;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(false);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new NullEntityResolver());
        Document existingDocument = builder.parse(existingFile);
        Document newDocument = builder.parse(newFile);
        DocumentType newDocType = newDocument.getDoctype();
        DocumentType existingDocType = existingDocument.getDoctype();
        if (!newDocType.getName().equals(existingDocType.getName())) {
            throw new ShellException(Messages.getString("Warning.12", existingFileName));
        }
        Element existingRootElement = existingDocument.getDocumentElement();
        Element newRootElement = newDocument.getDocumentElement();
        NamedNodeMap attributes = existingRootElement.getAttributes();
        int attributeCount = attributes.getLength();
        for (i = attributeCount - 1; i >= 0; --i) {
            node = attributes.item(i);
            existingRootElement.removeAttribute(node.getNodeName());
        }
        attributes = newRootElement.getAttributes();
        attributeCount = attributes.getLength();
        for (i = 0; i < attributeCount; ++i) {
            node = attributes.item(i);
            existingRootElement.setAttribute(node.getNodeName(), node.getNodeValue());
        }
        ArrayList<Node> nodesToDelete = new ArrayList<Node>();
        NodeList children = existingRootElement.getChildNodes();
        int length = children.getLength();
        for (int i2 = 0; i2 < length; ++i2) {
            Node node2 = children.item(i2);
            if (XmlFileMergerJaxp.isGeneratedNode(node2)) {
                nodesToDelete.add(node2);
                continue;
            }
            if (!XmlFileMergerJaxp.isWhiteSpace(node2) || !XmlFileMergerJaxp.isGeneratedNode(children.item(i2 + 1))) continue;
            nodesToDelete.add(node2);
        }
        for (Node node2 : nodesToDelete) {
            existingRootElement.removeChild(node2);
        }
        children = newRootElement.getChildNodes();
        length = children.getLength();
        Node firstChild = existingRootElement.getFirstChild();
        for (int i3 = 0; i3 < length; ++i3) {
            Node node3 = children.item(i3);
            if (i3 == length - 1 && XmlFileMergerJaxp.isWhiteSpace(node3)) break;
            Node newNode = existingDocument.importNode(node3, true);
            if (firstChild == null) {
                existingRootElement.appendChild(newNode);
                continue;
            }
            existingRootElement.insertBefore(newNode, firstChild);
        }
        return XmlFileMergerJaxp.prettyPrint(existingDocument);
    }

    private static String prettyPrint(Document document) throws ShellException {
        DomWriter dw = new DomWriter();
        return dw.toString(document);
    }

    private static boolean isGeneratedNode(Node node) {
        return node != null && node.getNodeType() == 1 && (XmlFileMergerJaxp.isOldFormatNode(node) || XmlFileMergerJaxp.isNewFormatNode(node));
    }

    private static boolean isOldFormatNode(Node node) {
        Element element = (Element)node;
        String id = element.getAttribute("id");
        if (id != null) {
            return MergeConstants.idStartsWithPrefix(id);
        }
        return false;
    }

    private static boolean isNewFormatNode(Node node) {
        NodeList children = node.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node childNode = children.item(i);
            if (childNode == null || childNode.getNodeType() != 8) continue;
            String commentData = ((Comment)childNode).getData();
            return MergeConstants.commentContainsTag(commentData);
        }
        return false;
    }

    private static boolean isWhiteSpace(Node node) {
        Text tn;
        boolean rc = false;
        if (node != null && node.getNodeType() == 3 && (tn = (Text)node).getData().trim().length() == 0) {
            rc = true;
        }
        return rc;
    }

    private static class NullEntityResolver
    implements EntityResolver {
        private NullEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            StringReader sr = new StringReader("");
            return new InputSource(sr);
        }
    }
}

