/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.config.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.stream.Collectors;
import org.mybatis.generator.config.ColumnOverride;
import org.mybatis.generator.config.ColumnRenamingRule;
import org.mybatis.generator.config.CommentGeneratorConfiguration;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.ConnectionFactoryConfiguration;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.DomainObjectRenamingRule;
import org.mybatis.generator.config.GeneratedKey;
import org.mybatis.generator.config.IgnoredColumn;
import org.mybatis.generator.config.IgnoredColumnException;
import org.mybatis.generator.config.IgnoredColumnPattern;
import org.mybatis.generator.config.JDBCConnectionConfiguration;
import org.mybatis.generator.config.JavaClientGeneratorConfiguration;
import org.mybatis.generator.config.JavaModelGeneratorConfiguration;
import org.mybatis.generator.config.JavaTypeResolverConfiguration;
import org.mybatis.generator.config.ModelType;
import org.mybatis.generator.config.PluginConfiguration;
import org.mybatis.generator.config.PropertyHolder;
import org.mybatis.generator.config.SqlMapGeneratorConfiguration;
import org.mybatis.generator.config.TableConfiguration;
import org.mybatis.generator.exception.XMLParserException;
import org.mybatis.generator.internal.ObjectFactory;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MyBatisGeneratorConfigurationParser {
    private Properties extraProperties;
    private Properties configurationProperties;

    public MyBatisGeneratorConfigurationParser(Properties extraProperties) {
        this.extraProperties = extraProperties == null ? new Properties() : extraProperties;
        this.configurationProperties = new Properties();
    }

    public Configuration parseConfiguration(Element rootNode) throws XMLParserException {
        Configuration configuration = new Configuration();
        NodeList nodeList = rootNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1) continue;
            if ("properties".equals(childNode.getNodeName())) {
                this.parseProperties(childNode);
                continue;
            }
            if ("classPathEntry".equals(childNode.getNodeName())) {
                this.parseClassPathEntry(configuration, childNode);
                continue;
            }
            if (!"context".equals(childNode.getNodeName())) continue;
            this.parseContext(configuration, childNode);
        }
        return configuration;
    }

    protected void parseProperties(Node node) throws XMLParserException {
        Properties attributes = this.parseAttributes(node);
        String resource = attributes.getProperty("resource");
        String url = attributes.getProperty("url");
        if (!StringUtility.stringHasValue(resource) && !StringUtility.stringHasValue(url)) {
            throw new XMLParserException(Messages.getString("RuntimeError.14"));
        }
        if (StringUtility.stringHasValue(resource) && StringUtility.stringHasValue(url)) {
            throw new XMLParserException(Messages.getString("RuntimeError.14"));
        }
        try {
            URL resourceUrl;
            if (StringUtility.stringHasValue(resource)) {
                resourceUrl = ObjectFactory.getResource(resource);
                if (resourceUrl == null) {
                    throw new XMLParserException(Messages.getString("RuntimeError.15", resource));
                }
            } else {
                resourceUrl = new URL(url);
            }
            InputStream inputStream = resourceUrl.openConnection().getInputStream();
            this.configurationProperties.load(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            if (StringUtility.stringHasValue(resource)) {
                throw new XMLParserException(Messages.getString("RuntimeError.16", resource));
            }
            throw new XMLParserException(Messages.getString("RuntimeError.17", url));
        }
    }

    private void parseContext(Configuration configuration, Node node) {
        Properties attributes = this.parseAttributes(node);
        String defaultModelType = attributes.getProperty("defaultModelType");
        String targetRuntime = attributes.getProperty("targetRuntime");
        String introspectedColumnImpl = attributes.getProperty("introspectedColumnImpl");
        String id = attributes.getProperty("id");
        ModelType mt = defaultModelType == null ? null : ModelType.getModelType(defaultModelType);
        Context context = new Context(mt);
        context.setId(id);
        if (StringUtility.stringHasValue(introspectedColumnImpl)) {
            context.setIntrospectedColumnImpl(introspectedColumnImpl);
        }
        if (StringUtility.stringHasValue(targetRuntime)) {
            context.setTargetRuntime(targetRuntime);
        }
        configuration.addContext(context);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1) continue;
            if ("property".equals(childNode.getNodeName())) {
                this.parseProperty(context, childNode);
                continue;
            }
            if ("plugin".equals(childNode.getNodeName())) {
                this.parsePlugin(context, childNode);
                continue;
            }
            if ("commentGenerator".equals(childNode.getNodeName())) {
                this.parseCommentGenerator(context, childNode);
                continue;
            }
            if ("jdbcConnection".equals(childNode.getNodeName())) {
                this.parseJdbcConnection(context, childNode);
                continue;
            }
            if ("connectionFactory".equals(childNode.getNodeName())) {
                this.parseConnectionFactory(context, childNode);
                continue;
            }
            if ("javaModelGenerator".equals(childNode.getNodeName())) {
                this.parseJavaModelGenerator(context, childNode);
                continue;
            }
            if ("javaTypeResolver".equals(childNode.getNodeName())) {
                this.parseJavaTypeResolver(context, childNode);
                continue;
            }
            if ("sqlMapGenerator".equals(childNode.getNodeName())) {
                this.parseSqlMapGenerator(context, childNode);
                continue;
            }
            if ("javaClientGenerator".equals(childNode.getNodeName())) {
                this.parseJavaClientGenerator(context, childNode);
                continue;
            }
            if (!"table".equals(childNode.getNodeName())) continue;
            this.parseTable(context, childNode);
        }
    }

    protected void parseSqlMapGenerator(Context context, Node node) {
        SqlMapGeneratorConfiguration sqlMapGeneratorConfiguration = new SqlMapGeneratorConfiguration();
        context.setSqlMapGeneratorConfiguration(sqlMapGeneratorConfiguration);
        Properties attributes = this.parseAttributes(node);
        String targetPackage = attributes.getProperty("targetPackage");
        String targetProject = attributes.getProperty("targetProject");
        sqlMapGeneratorConfiguration.setTargetPackage(targetPackage);
        sqlMapGeneratorConfiguration.setTargetProject(targetProject);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1 || !"property".equals(childNode.getNodeName())) continue;
            this.parseProperty(sqlMapGeneratorConfiguration, childNode);
        }
    }

    protected void parseTable(Context context, Node node) {
        String sqlProviderName;
        String mapperName;
        String delimitAllColumns;
        String delimitIdentifiers;
        String escapeWildcards;
        String modelType;
        String selectByExampleQueryId;
        String selectByPrimaryKeyQueryId;
        String enableUpdateByExample;
        String enableCountByExample;
        String enableDeleteByExample;
        String enableDeleteByPrimaryKey;
        String enableUpdateByPrimaryKey;
        String enableSelectByExample;
        String enableSelectByPrimaryKey;
        String enableInsert;
        String alias;
        String domainObjectName;
        String tableName;
        String schema;
        TableConfiguration tc = new TableConfiguration(context);
        context.addTableConfiguration(tc);
        Properties attributes = this.parseAttributes(node);
        String catalog = attributes.getProperty("catalog");
        if (StringUtility.stringHasValue(catalog)) {
            tc.setCatalog(catalog);
        }
        if (StringUtility.stringHasValue(schema = attributes.getProperty("schema"))) {
            tc.setSchema(schema);
        }
        if (StringUtility.stringHasValue(tableName = attributes.getProperty("tableName"))) {
            tc.setTableName(tableName);
        }
        if (StringUtility.stringHasValue(domainObjectName = attributes.getProperty("domainObjectName"))) {
            tc.setDomainObjectName(domainObjectName);
        }
        if (StringUtility.stringHasValue(alias = attributes.getProperty("alias"))) {
            tc.setAlias(alias);
        }
        if (StringUtility.stringHasValue(enableInsert = attributes.getProperty("enableInsert"))) {
            tc.setInsertStatementEnabled(StringUtility.isTrue(enableInsert));
        }
        if (StringUtility.stringHasValue(enableSelectByPrimaryKey = attributes.getProperty("enableSelectByPrimaryKey"))) {
            tc.setSelectByPrimaryKeyStatementEnabled(StringUtility.isTrue(enableSelectByPrimaryKey));
        }
        if (StringUtility.stringHasValue(enableSelectByExample = attributes.getProperty("enableSelectByExample"))) {
            tc.setSelectByExampleStatementEnabled(StringUtility.isTrue(enableSelectByExample));
        }
        if (StringUtility.stringHasValue(enableUpdateByPrimaryKey = attributes.getProperty("enableUpdateByPrimaryKey"))) {
            tc.setUpdateByPrimaryKeyStatementEnabled(StringUtility.isTrue(enableUpdateByPrimaryKey));
        }
        if (StringUtility.stringHasValue(enableDeleteByPrimaryKey = attributes.getProperty("enableDeleteByPrimaryKey"))) {
            tc.setDeleteByPrimaryKeyStatementEnabled(StringUtility.isTrue(enableDeleteByPrimaryKey));
        }
        if (StringUtility.stringHasValue(enableDeleteByExample = attributes.getProperty("enableDeleteByExample"))) {
            tc.setDeleteByExampleStatementEnabled(StringUtility.isTrue(enableDeleteByExample));
        }
        if (StringUtility.stringHasValue(enableCountByExample = attributes.getProperty("enableCountByExample"))) {
            tc.setCountByExampleStatementEnabled(StringUtility.isTrue(enableCountByExample));
        }
        if (StringUtility.stringHasValue(enableUpdateByExample = attributes.getProperty("enableUpdateByExample"))) {
            tc.setUpdateByExampleStatementEnabled(StringUtility.isTrue(enableUpdateByExample));
        }
        if (StringUtility.stringHasValue(selectByPrimaryKeyQueryId = attributes.getProperty("selectByPrimaryKeyQueryId"))) {
            tc.setSelectByPrimaryKeyQueryId(selectByPrimaryKeyQueryId);
        }
        if (StringUtility.stringHasValue(selectByExampleQueryId = attributes.getProperty("selectByExampleQueryId"))) {
            tc.setSelectByExampleQueryId(selectByExampleQueryId);
        }
        if (StringUtility.stringHasValue(modelType = attributes.getProperty("modelType"))) {
            tc.setConfiguredModelType(modelType);
        }
        if (StringUtility.stringHasValue(escapeWildcards = attributes.getProperty("escapeWildcards"))) {
            tc.setWildcardEscapingEnabled(StringUtility.isTrue(escapeWildcards));
        }
        if (StringUtility.stringHasValue(delimitIdentifiers = attributes.getProperty("delimitIdentifiers"))) {
            tc.setDelimitIdentifiers(StringUtility.isTrue(delimitIdentifiers));
        }
        if (StringUtility.stringHasValue(delimitAllColumns = attributes.getProperty("delimitAllColumns"))) {
            tc.setAllColumnDelimitingEnabled(StringUtility.isTrue(delimitAllColumns));
        }
        if (StringUtility.stringHasValue(mapperName = attributes.getProperty("mapperName"))) {
            tc.setMapperName(mapperName);
        }
        if (StringUtility.stringHasValue(sqlProviderName = attributes.getProperty("sqlProviderName"))) {
            tc.setSqlProviderName(sqlProviderName);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1) continue;
            if ("property".equals(childNode.getNodeName())) {
                this.parseProperty(tc, childNode);
                continue;
            }
            if ("columnOverride".equals(childNode.getNodeName())) {
                this.parseColumnOverride(tc, childNode);
                continue;
            }
            if ("ignoreColumn".equals(childNode.getNodeName())) {
                this.parseIgnoreColumn(tc, childNode);
                continue;
            }
            if ("ignoreColumnsByRegex".equals(childNode.getNodeName())) {
                this.parseIgnoreColumnByRegex(tc, childNode);
                continue;
            }
            if ("generatedKey".equals(childNode.getNodeName())) {
                this.parseGeneratedKey(tc, childNode);
                continue;
            }
            if ("domainObjectRenamingRule".equals(childNode.getNodeName())) {
                this.parseDomainObjectRenamingRule(tc, childNode);
                continue;
            }
            if (!"columnRenamingRule".equals(childNode.getNodeName())) continue;
            this.parseColumnRenamingRule(tc, childNode);
        }
    }

    private void parseColumnOverride(TableConfiguration tc, Node node) {
        String isGeneratedAlways;
        String delimitedColumnName;
        String typeHandler;
        String jdbcType;
        String javaType;
        Properties attributes = this.parseAttributes(node);
        String column = attributes.getProperty("column");
        ColumnOverride co = new ColumnOverride(column);
        String property = attributes.getProperty("property");
        if (StringUtility.stringHasValue(property)) {
            co.setJavaProperty(property);
        }
        if (StringUtility.stringHasValue(javaType = attributes.getProperty("javaType"))) {
            co.setJavaType(javaType);
        }
        if (StringUtility.stringHasValue(jdbcType = attributes.getProperty("jdbcType"))) {
            co.setJdbcType(jdbcType);
        }
        if (StringUtility.stringHasValue(typeHandler = attributes.getProperty("typeHandler"))) {
            co.setTypeHandler(typeHandler);
        }
        if (StringUtility.stringHasValue(delimitedColumnName = attributes.getProperty("delimitedColumnName"))) {
            co.setColumnNameDelimited(StringUtility.isTrue(delimitedColumnName));
        }
        if (StringUtility.stringHasValue(isGeneratedAlways = attributes.getProperty("isGeneratedAlways"))) {
            co.setGeneratedAlways(Boolean.parseBoolean(isGeneratedAlways));
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1 || !"property".equals(childNode.getNodeName())) continue;
            this.parseProperty(co, childNode);
        }
        tc.addColumnOverride(co);
    }

    private void parseGeneratedKey(TableConfiguration tc, Node node) {
        Properties attributes = this.parseAttributes(node);
        String column = attributes.getProperty("column");
        boolean identity = StringUtility.isTrue(attributes.getProperty("identity"));
        String sqlStatement = attributes.getProperty("sqlStatement");
        String type = attributes.getProperty("type");
        GeneratedKey gk = new GeneratedKey(column, sqlStatement, identity, type);
        tc.setGeneratedKey(gk);
    }

    private void parseIgnoreColumn(TableConfiguration tc, Node node) {
        Properties attributes = this.parseAttributes(node);
        String column = attributes.getProperty("column");
        String delimitedColumnName = attributes.getProperty("delimitedColumnName");
        IgnoredColumn ic = new IgnoredColumn(column);
        if (StringUtility.stringHasValue(delimitedColumnName)) {
            ic.setColumnNameDelimited(StringUtility.isTrue(delimitedColumnName));
        }
        tc.addIgnoredColumn(ic);
    }

    private void parseIgnoreColumnByRegex(TableConfiguration tc, Node node) {
        Properties attributes = this.parseAttributes(node);
        String pattern = attributes.getProperty("pattern");
        IgnoredColumnPattern icPattern = new IgnoredColumnPattern(pattern);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1 || !"except".equals(childNode.getNodeName())) continue;
            this.parseException(icPattern, childNode);
        }
        tc.addIgnoredColumnPattern(icPattern);
    }

    private void parseException(IgnoredColumnPattern icPattern, Node node) {
        Properties attributes = this.parseAttributes(node);
        String column = attributes.getProperty("column");
        String delimitedColumnName = attributes.getProperty("delimitedColumnName");
        IgnoredColumnException exception = new IgnoredColumnException(column);
        if (StringUtility.stringHasValue(delimitedColumnName)) {
            exception.setColumnNameDelimited(StringUtility.isTrue(delimitedColumnName));
        }
        icPattern.addException(exception);
    }

    private void parseDomainObjectRenamingRule(TableConfiguration tc, Node node) {
        Properties attributes = this.parseAttributes(node);
        String searchString = attributes.getProperty("searchString");
        String replaceString = attributes.getProperty("replaceString");
        DomainObjectRenamingRule dorr = new DomainObjectRenamingRule();
        dorr.setSearchString(searchString);
        if (StringUtility.stringHasValue(replaceString)) {
            dorr.setReplaceString(replaceString);
        }
        tc.setDomainObjectRenamingRule(dorr);
    }

    private void parseColumnRenamingRule(TableConfiguration tc, Node node) {
        Properties attributes = this.parseAttributes(node);
        String searchString = attributes.getProperty("searchString");
        String replaceString = attributes.getProperty("replaceString");
        ColumnRenamingRule crr = new ColumnRenamingRule();
        crr.setSearchString(searchString);
        if (StringUtility.stringHasValue(replaceString)) {
            crr.setReplaceString(replaceString);
        }
        tc.setColumnRenamingRule(crr);
    }

    protected void parseJavaTypeResolver(Context context, Node node) {
        JavaTypeResolverConfiguration javaTypeResolverConfiguration = new JavaTypeResolverConfiguration();
        context.setJavaTypeResolverConfiguration(javaTypeResolverConfiguration);
        Properties attributes = this.parseAttributes(node);
        String type = attributes.getProperty("type");
        if (StringUtility.stringHasValue(type)) {
            javaTypeResolverConfiguration.setConfigurationType(type);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1 || !"property".equals(childNode.getNodeName())) continue;
            this.parseProperty(javaTypeResolverConfiguration, childNode);
        }
    }

    private void parsePlugin(Context context, Node node) {
        PluginConfiguration pluginConfiguration = new PluginConfiguration();
        context.addPluginConfiguration(pluginConfiguration);
        Properties attributes = this.parseAttributes(node);
        String type = attributes.getProperty("type");
        pluginConfiguration.setConfigurationType(type);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1 || !"property".equals(childNode.getNodeName())) continue;
            this.parseProperty(pluginConfiguration, childNode);
        }
    }

    protected void parseJavaModelGenerator(Context context, Node node) {
        JavaModelGeneratorConfiguration javaModelGeneratorConfiguration = new JavaModelGeneratorConfiguration();
        context.setJavaModelGeneratorConfiguration(javaModelGeneratorConfiguration);
        Properties attributes = this.parseAttributes(node);
        String targetPackage = attributes.getProperty("targetPackage");
        String targetProject = attributes.getProperty("targetProject");
        javaModelGeneratorConfiguration.setTargetPackage(targetPackage);
        javaModelGeneratorConfiguration.setTargetProject(targetProject);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1 || !"property".equals(childNode.getNodeName())) continue;
            this.parseProperty(javaModelGeneratorConfiguration, childNode);
        }
    }

    private void parseJavaClientGenerator(Context context, Node node) {
        JavaClientGeneratorConfiguration javaClientGeneratorConfiguration = new JavaClientGeneratorConfiguration();
        context.setJavaClientGeneratorConfiguration(javaClientGeneratorConfiguration);
        Properties attributes = this.parseAttributes(node);
        String type = attributes.getProperty("type");
        String targetPackage = attributes.getProperty("targetPackage");
        String targetProject = attributes.getProperty("targetProject");
        javaClientGeneratorConfiguration.setConfigurationType(type);
        javaClientGeneratorConfiguration.setTargetPackage(targetPackage);
        javaClientGeneratorConfiguration.setTargetProject(targetProject);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1 || !"property".equals(childNode.getNodeName())) continue;
            this.parseProperty(javaClientGeneratorConfiguration, childNode);
        }
    }

    protected void parseJdbcConnection(Context context, Node node) {
        String password;
        JDBCConnectionConfiguration jdbcConnectionConfiguration = new JDBCConnectionConfiguration();
        context.setJdbcConnectionConfiguration(jdbcConnectionConfiguration);
        Properties attributes = this.parseAttributes(node);
        String driverClass = attributes.getProperty("driverClass");
        String connectionURL = attributes.getProperty("connectionURL");
        jdbcConnectionConfiguration.setDriverClass(driverClass);
        jdbcConnectionConfiguration.setConnectionURL(connectionURL);
        String userId = attributes.getProperty("userId");
        if (StringUtility.stringHasValue(userId)) {
            jdbcConnectionConfiguration.setUserId(userId);
        }
        if (StringUtility.stringHasValue(password = attributes.getProperty("password"))) {
            jdbcConnectionConfiguration.setPassword(password);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1 || !"property".equals(childNode.getNodeName())) continue;
            this.parseProperty(jdbcConnectionConfiguration, childNode);
        }
    }

    protected void parseClassPathEntry(Configuration configuration, Node node) {
        Properties attributes = this.parseAttributes(node);
        configuration.addClasspathEntry(attributes.getProperty("location"));
    }

    protected void parseProperty(PropertyHolder propertyHolder, Node node) {
        Properties attributes = this.parseAttributes(node);
        String name = attributes.getProperty("name");
        String value = attributes.getProperty("value");
        propertyHolder.addProperty(name, value);
    }

    protected Properties parseAttributes(Node node) {
        Properties attributes = new Properties();
        NamedNodeMap nnm = node.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node attribute = nnm.item(i);
            String value = this.parsePropertyTokens(attribute.getNodeValue());
            attributes.put(attribute.getNodeName(), value);
        }
        return attributes;
    }

    String parsePropertyTokens(String s) {
        String OPEN = "${";
        String CLOSE = "}";
        int currentIndex = 0;
        ArrayList<String> answer = new ArrayList<String>();
        int markerStartIndex = s.indexOf("${");
        if (markerStartIndex < 0) {
            answer.add(s);
            currentIndex = s.length();
        }
        while (markerStartIndex > -1) {
            if (markerStartIndex > currentIndex) {
                answer.add(s.substring(currentIndex, markerStartIndex));
                currentIndex = markerStartIndex;
            }
            int markerEndIndex = s.indexOf("}", currentIndex);
            int nestedStartIndex = s.indexOf("${", markerStartIndex + "${".length());
            while (nestedStartIndex > -1 && markerEndIndex > -1 && nestedStartIndex < markerEndIndex) {
                nestedStartIndex = s.indexOf("${", nestedStartIndex + "${".length());
                markerEndIndex = s.indexOf("}", markerEndIndex + "}".length());
            }
            if (markerEndIndex < 0) {
                answer.add(s.substring(markerStartIndex));
                currentIndex = s.length();
                break;
            }
            String property = s.substring(markerStartIndex + "${".length(), markerEndIndex);
            String propertyValue = this.resolveProperty(this.parsePropertyTokens(property));
            if (propertyValue == null) {
                answer.add(s.substring(markerStartIndex, markerEndIndex + 1));
            } else {
                answer.add(propertyValue);
            }
            currentIndex = markerEndIndex + "}".length();
            markerStartIndex = s.indexOf("${", currentIndex);
        }
        if (currentIndex < s.length()) {
            answer.add(s.substring(currentIndex));
        }
        return answer.stream().collect(Collectors.joining());
    }

    protected void parseCommentGenerator(Context context, Node node) {
        CommentGeneratorConfiguration commentGeneratorConfiguration = new CommentGeneratorConfiguration();
        context.setCommentGeneratorConfiguration(commentGeneratorConfiguration);
        Properties attributes = this.parseAttributes(node);
        String type = attributes.getProperty("type");
        if (StringUtility.stringHasValue(type)) {
            commentGeneratorConfiguration.setConfigurationType(type);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1 || !"property".equals(childNode.getNodeName())) continue;
            this.parseProperty(commentGeneratorConfiguration, childNode);
        }
    }

    protected void parseConnectionFactory(Context context, Node node) {
        ConnectionFactoryConfiguration connectionFactoryConfiguration = new ConnectionFactoryConfiguration();
        context.setConnectionFactoryConfiguration(connectionFactoryConfiguration);
        Properties attributes = this.parseAttributes(node);
        String type = attributes.getProperty("type");
        if (StringUtility.stringHasValue(type)) {
            connectionFactoryConfiguration.setConfigurationType(type);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1 || !"property".equals(childNode.getNodeName())) continue;
            this.parseProperty(connectionFactoryConfiguration, childNode);
        }
    }

    private String resolveProperty(String key) {
        String property = null;
        property = System.getProperty(key);
        if (property == null) {
            property = this.configurationProperties.getProperty(key);
        }
        if (property == null) {
            property = this.extraProperties.getProperty(key);
        }
        return property;
    }
}

