/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mybatis.generator.config.ColumnOverride;
import org.mybatis.generator.config.ColumnRenamingRule;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.DomainObjectRenamingRule;
import org.mybatis.generator.config.GeneratedKey;
import org.mybatis.generator.config.IgnoredColumn;
import org.mybatis.generator.config.IgnoredColumnPattern;
import org.mybatis.generator.config.ModelType;
import org.mybatis.generator.config.PropertyHolder;
import org.mybatis.generator.internal.util.EqualsUtil;
import org.mybatis.generator.internal.util.HashCodeUtil;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public class TableConfiguration
extends PropertyHolder {
    private boolean insertStatementEnabled;
    private boolean selectByPrimaryKeyStatementEnabled;
    private boolean selectByExampleStatementEnabled;
    private boolean updateByPrimaryKeyStatementEnabled;
    private boolean deleteByPrimaryKeyStatementEnabled;
    private boolean deleteByExampleStatementEnabled;
    private boolean countByExampleStatementEnabled;
    private boolean updateByExampleStatementEnabled;
    private List<ColumnOverride> columnOverrides;
    private Map<IgnoredColumn, Boolean> ignoredColumns;
    private GeneratedKey generatedKey;
    private String selectByPrimaryKeyQueryId;
    private String selectByExampleQueryId;
    private String catalog;
    private String schema;
    private String tableName;
    private String domainObjectName;
    private String alias;
    private ModelType modelType;
    private boolean wildcardEscapingEnabled;
    private boolean delimitIdentifiers;
    private DomainObjectRenamingRule domainObjectRenamingRule;
    private ColumnRenamingRule columnRenamingRule;
    private boolean isAllColumnDelimitingEnabled;
    private String mapperName;
    private String sqlProviderName;
    private List<IgnoredColumnPattern> ignoredColumnPatterns = new ArrayList<IgnoredColumnPattern>();

    public TableConfiguration(Context context) {
        this.modelType = context.getDefaultModelType();
        this.columnOverrides = new ArrayList<ColumnOverride>();
        this.ignoredColumns = new HashMap<IgnoredColumn, Boolean>();
        this.insertStatementEnabled = true;
        this.selectByPrimaryKeyStatementEnabled = true;
        this.selectByExampleStatementEnabled = true;
        this.updateByPrimaryKeyStatementEnabled = true;
        this.deleteByPrimaryKeyStatementEnabled = true;
        this.deleteByExampleStatementEnabled = true;
        this.countByExampleStatementEnabled = true;
        this.updateByExampleStatementEnabled = true;
    }

    public boolean isDeleteByPrimaryKeyStatementEnabled() {
        return this.deleteByPrimaryKeyStatementEnabled;
    }

    public void setDeleteByPrimaryKeyStatementEnabled(boolean deleteByPrimaryKeyStatementEnabled) {
        this.deleteByPrimaryKeyStatementEnabled = deleteByPrimaryKeyStatementEnabled;
    }

    public boolean isInsertStatementEnabled() {
        return this.insertStatementEnabled;
    }

    public void setInsertStatementEnabled(boolean insertStatementEnabled) {
        this.insertStatementEnabled = insertStatementEnabled;
    }

    public boolean isSelectByPrimaryKeyStatementEnabled() {
        return this.selectByPrimaryKeyStatementEnabled;
    }

    public void setSelectByPrimaryKeyStatementEnabled(boolean selectByPrimaryKeyStatementEnabled) {
        this.selectByPrimaryKeyStatementEnabled = selectByPrimaryKeyStatementEnabled;
    }

    public boolean isUpdateByPrimaryKeyStatementEnabled() {
        return this.updateByPrimaryKeyStatementEnabled;
    }

    public void setUpdateByPrimaryKeyStatementEnabled(boolean updateByPrimaryKeyStatementEnabled) {
        this.updateByPrimaryKeyStatementEnabled = updateByPrimaryKeyStatementEnabled;
    }

    public boolean isColumnIgnored(String columnName) {
        for (Map.Entry<IgnoredColumn, Boolean> entry : this.ignoredColumns.entrySet()) {
            if (!entry.getKey().matches(columnName)) continue;
            entry.setValue(Boolean.TRUE);
            return true;
        }
        for (IgnoredColumnPattern ignoredColumnPattern : this.ignoredColumnPatterns) {
            if (!ignoredColumnPattern.matches(columnName)) continue;
            return true;
        }
        return false;
    }

    public void addIgnoredColumn(IgnoredColumn ignoredColumn) {
        this.ignoredColumns.put(ignoredColumn, Boolean.FALSE);
    }

    public void addIgnoredColumnPattern(IgnoredColumnPattern ignoredColumnPattern) {
        this.ignoredColumnPatterns.add(ignoredColumnPattern);
    }

    public void addColumnOverride(ColumnOverride columnOverride) {
        this.columnOverrides.add(columnOverride);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TableConfiguration)) {
            return false;
        }
        TableConfiguration other = (TableConfiguration)obj;
        return EqualsUtil.areEqual(this.catalog, other.catalog) && EqualsUtil.areEqual(this.schema, other.schema) && EqualsUtil.areEqual(this.tableName, other.tableName);
    }

    public int hashCode() {
        int result = 23;
        result = HashCodeUtil.hash(result, this.catalog);
        result = HashCodeUtil.hash(result, this.schema);
        result = HashCodeUtil.hash(result, this.tableName);
        return result;
    }

    public boolean isSelectByExampleStatementEnabled() {
        return this.selectByExampleStatementEnabled;
    }

    public void setSelectByExampleStatementEnabled(boolean selectByExampleStatementEnabled) {
        this.selectByExampleStatementEnabled = selectByExampleStatementEnabled;
    }

    public ColumnOverride getColumnOverride(String columnName) {
        for (ColumnOverride co : this.columnOverrides) {
            if (!(co.isColumnNameDelimited() ? columnName.equals(co.getColumnName()) : columnName.equalsIgnoreCase(co.getColumnName()))) continue;
            return co;
        }
        return null;
    }

    public GeneratedKey getGeneratedKey() {
        return this.generatedKey;
    }

    public String getSelectByExampleQueryId() {
        return this.selectByExampleQueryId;
    }

    public void setSelectByExampleQueryId(String selectByExampleQueryId) {
        this.selectByExampleQueryId = selectByExampleQueryId;
    }

    public String getSelectByPrimaryKeyQueryId() {
        return this.selectByPrimaryKeyQueryId;
    }

    public void setSelectByPrimaryKeyQueryId(String selectByPrimaryKeyQueryId) {
        this.selectByPrimaryKeyQueryId = selectByPrimaryKeyQueryId;
    }

    public boolean isDeleteByExampleStatementEnabled() {
        return this.deleteByExampleStatementEnabled;
    }

    public void setDeleteByExampleStatementEnabled(boolean deleteByExampleStatementEnabled) {
        this.deleteByExampleStatementEnabled = deleteByExampleStatementEnabled;
    }

    public boolean areAnyStatementsEnabled() {
        return this.selectByExampleStatementEnabled || this.selectByPrimaryKeyStatementEnabled || this.insertStatementEnabled || this.updateByPrimaryKeyStatementEnabled || this.deleteByExampleStatementEnabled || this.deleteByPrimaryKeyStatementEnabled || this.countByExampleStatementEnabled || this.updateByExampleStatementEnabled;
    }

    public void setGeneratedKey(GeneratedKey generatedKey) {
        this.generatedKey = generatedKey;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getDomainObjectName() {
        return this.domainObjectName;
    }

    public void setDomainObjectName(String domainObjectName) {
        this.domainObjectName = domainObjectName;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<ColumnOverride> getColumnOverrides() {
        return this.columnOverrides;
    }

    public List<String> getIgnoredColumnsInError() {
        ArrayList<String> answer = new ArrayList<String>();
        for (Map.Entry<IgnoredColumn, Boolean> entry : this.ignoredColumns.entrySet()) {
            if (!Boolean.FALSE.equals(entry.getValue())) continue;
            answer.add(entry.getKey().getColumnName());
        }
        return answer;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public void setConfiguredModelType(String configuredModelType) {
        this.modelType = ModelType.getModelType(configuredModelType);
    }

    public boolean isWildcardEscapingEnabled() {
        return this.wildcardEscapingEnabled;
    }

    public void setWildcardEscapingEnabled(boolean wildcardEscapingEnabled) {
        this.wildcardEscapingEnabled = wildcardEscapingEnabled;
    }

    public String toString() {
        return StringUtility.composeFullyQualifiedTableName(this.catalog, this.schema, this.tableName, '.');
    }

    public boolean isDelimitIdentifiers() {
        return this.delimitIdentifiers;
    }

    public void setDelimitIdentifiers(boolean delimitIdentifiers) {
        this.delimitIdentifiers = delimitIdentifiers;
    }

    public boolean isCountByExampleStatementEnabled() {
        return this.countByExampleStatementEnabled;
    }

    public void setCountByExampleStatementEnabled(boolean countByExampleStatementEnabled) {
        this.countByExampleStatementEnabled = countByExampleStatementEnabled;
    }

    public boolean isUpdateByExampleStatementEnabled() {
        return this.updateByExampleStatementEnabled;
    }

    public void setUpdateByExampleStatementEnabled(boolean updateByExampleStatementEnabled) {
        this.updateByExampleStatementEnabled = updateByExampleStatementEnabled;
    }

    public void validate(List<String> errors, int listPosition) {
        boolean queryId2Set;
        boolean queryId1Set;
        if (!StringUtility.stringHasValue(this.tableName)) {
            errors.add(Messages.getString("ValidationError.6", Integer.toString(listPosition)));
        }
        String fqTableName = StringUtility.composeFullyQualifiedTableName(this.catalog, this.schema, this.tableName, '.');
        if (this.generatedKey != null) {
            this.generatedKey.validate(errors, fqTableName);
        }
        if (StringUtility.isTrue(this.getProperty("useColumnIndexes")) && this.selectByExampleStatementEnabled && this.selectByPrimaryKeyStatementEnabled && (queryId1Set = StringUtility.stringHasValue(this.selectByExampleQueryId)) != (queryId2Set = StringUtility.stringHasValue(this.selectByPrimaryKeyQueryId))) {
            errors.add(Messages.getString("ValidationError.13", fqTableName));
        }
        if (this.domainObjectRenamingRule != null) {
            this.domainObjectRenamingRule.validate(errors, fqTableName);
        }
        if (this.columnRenamingRule != null) {
            this.columnRenamingRule.validate(errors, fqTableName);
        }
        for (ColumnOverride columnOverride : this.columnOverrides) {
            columnOverride.validate(errors, fqTableName);
        }
        for (IgnoredColumn ignoredColumn : this.ignoredColumns.keySet()) {
            ignoredColumn.validate(errors, fqTableName);
        }
        for (IgnoredColumnPattern ignoredColumnPattern : this.ignoredColumnPatterns) {
            ignoredColumnPattern.validate(errors, fqTableName);
        }
    }

    public DomainObjectRenamingRule getDomainObjectRenamingRule() {
        return this.domainObjectRenamingRule;
    }

    public void setDomainObjectRenamingRule(DomainObjectRenamingRule domainObjectRenamingRule) {
        this.domainObjectRenamingRule = domainObjectRenamingRule;
    }

    public ColumnRenamingRule getColumnRenamingRule() {
        return this.columnRenamingRule;
    }

    public void setColumnRenamingRule(ColumnRenamingRule columnRenamingRule) {
        this.columnRenamingRule = columnRenamingRule;
    }

    public boolean isAllColumnDelimitingEnabled() {
        return this.isAllColumnDelimitingEnabled;
    }

    public void setAllColumnDelimitingEnabled(boolean isAllColumnDelimitingEnabled) {
        this.isAllColumnDelimitingEnabled = isAllColumnDelimitingEnabled;
    }

    public String getMapperName() {
        return this.mapperName;
    }

    public void setMapperName(String mapperName) {
        this.mapperName = mapperName;
    }

    public String getSqlProviderName() {
        return this.sqlProviderName;
    }

    public void setSqlProviderName(String sqlProviderName) {
        this.sqlProviderName = sqlProviderName;
    }
}

