/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.config;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.mybatis.generator.config.IgnoredColumnException;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public class IgnoredColumnPattern {
    private String patternRegex;
    private Pattern pattern;
    private List<IgnoredColumnException> exceptions = new ArrayList<IgnoredColumnException>();

    public IgnoredColumnPattern(String patternRegex) {
        this.patternRegex = patternRegex;
        this.pattern = Pattern.compile(patternRegex);
    }

    public void addException(IgnoredColumnException exception) {
        this.exceptions.add(exception);
    }

    public boolean matches(String columnName) {
        boolean matches = this.pattern.matcher(columnName).matches();
        if (matches) {
            for (IgnoredColumnException exception : this.exceptions) {
                if (!exception.matches(columnName)) continue;
                matches = false;
                break;
            }
        }
        return matches;
    }

    public void validate(List<String> errors, String tableName) {
        if (!StringUtility.stringHasValue(this.patternRegex)) {
            errors.add(Messages.getString("ValidationError.27", tableName));
        }
    }
}

