/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.config;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.ConnectionFactory;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.GeneratedKotlinFile;
import org.mybatis.generator.api.GeneratedXmlFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.JavaFormatter;
import org.mybatis.generator.api.JavaTypeResolver;
import org.mybatis.generator.api.KotlinFormatter;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.ProgressCallback;
import org.mybatis.generator.api.XmlFormatter;
import org.mybatis.generator.config.CommentGeneratorConfiguration;
import org.mybatis.generator.config.ConnectionFactoryConfiguration;
import org.mybatis.generator.config.JDBCConnectionConfiguration;
import org.mybatis.generator.config.JavaClientGeneratorConfiguration;
import org.mybatis.generator.config.JavaModelGeneratorConfiguration;
import org.mybatis.generator.config.JavaTypeResolverConfiguration;
import org.mybatis.generator.config.ModelType;
import org.mybatis.generator.config.PluginConfiguration;
import org.mybatis.generator.config.PropertyHolder;
import org.mybatis.generator.config.SqlMapGeneratorConfiguration;
import org.mybatis.generator.config.TableConfiguration;
import org.mybatis.generator.internal.JDBCConnectionFactory;
import org.mybatis.generator.internal.ObjectFactory;
import org.mybatis.generator.internal.PluginAggregator;
import org.mybatis.generator.internal.db.DatabaseIntrospector;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public class Context
extends PropertyHolder {
    private String id;
    private JDBCConnectionConfiguration jdbcConnectionConfiguration;
    private ConnectionFactoryConfiguration connectionFactoryConfiguration;
    private SqlMapGeneratorConfiguration sqlMapGeneratorConfiguration;
    private JavaTypeResolverConfiguration javaTypeResolverConfiguration;
    private JavaModelGeneratorConfiguration javaModelGeneratorConfiguration;
    private JavaClientGeneratorConfiguration javaClientGeneratorConfiguration;
    private ArrayList<TableConfiguration> tableConfigurations;
    private ModelType defaultModelType;
    private String beginningDelimiter = "\"";
    private String endingDelimiter = "\"";
    private CommentGeneratorConfiguration commentGeneratorConfiguration;
    private CommentGenerator commentGenerator;
    private PluginAggregator pluginAggregator;
    private List<PluginConfiguration> pluginConfigurations;
    private String targetRuntime;
    private String introspectedColumnImpl;
    private Boolean autoDelimitKeywords;
    private JavaFormatter javaFormatter;
    private KotlinFormatter kotlinFormatter;
    private XmlFormatter xmlFormatter;
    private boolean isJava8Targeted = true;
    private List<IntrospectedTable> introspectedTables;

    public Context(ModelType defaultModelType) {
        this.defaultModelType = defaultModelType == null ? ModelType.CONDITIONAL : defaultModelType;
        this.tableConfigurations = new ArrayList();
        this.pluginConfigurations = new ArrayList<PluginConfiguration>();
    }

    public void addTableConfiguration(TableConfiguration tc) {
        this.tableConfigurations.add(tc);
    }

    public JDBCConnectionConfiguration getJdbcConnectionConfiguration() {
        return this.jdbcConnectionConfiguration;
    }

    public JavaClientGeneratorConfiguration getJavaClientGeneratorConfiguration() {
        return this.javaClientGeneratorConfiguration;
    }

    public JavaModelGeneratorConfiguration getJavaModelGeneratorConfiguration() {
        return this.javaModelGeneratorConfiguration;
    }

    public JavaTypeResolverConfiguration getJavaTypeResolverConfiguration() {
        return this.javaTypeResolverConfiguration;
    }

    public SqlMapGeneratorConfiguration getSqlMapGeneratorConfiguration() {
        return this.sqlMapGeneratorConfiguration;
    }

    public void addPluginConfiguration(PluginConfiguration pluginConfiguration) {
        this.pluginConfigurations.add(pluginConfiguration);
    }

    public void validate(List<String> errors) {
        if (!StringUtility.stringHasValue(this.id)) {
            errors.add(Messages.getString("ValidationError.16"));
        }
        if (this.jdbcConnectionConfiguration == null && this.connectionFactoryConfiguration == null) {
            errors.add(Messages.getString("ValidationError.10", this.id));
        } else if (this.jdbcConnectionConfiguration != null && this.connectionFactoryConfiguration != null) {
            errors.add(Messages.getString("ValidationError.10", this.id));
        } else if (this.jdbcConnectionConfiguration != null) {
            this.jdbcConnectionConfiguration.validate(errors);
        } else {
            this.connectionFactoryConfiguration.validate(errors);
        }
        if (this.javaModelGeneratorConfiguration == null) {
            errors.add(Messages.getString("ValidationError.8", this.id));
        } else {
            this.javaModelGeneratorConfiguration.validate(errors, this.id);
        }
        if (this.javaClientGeneratorConfiguration != null) {
            this.javaClientGeneratorConfiguration.validate(errors, this.id);
        }
        IntrospectedTable it = null;
        try {
            it = ObjectFactory.createIntrospectedTableForValidation(this);
        }
        catch (Exception e) {
            errors.add(Messages.getString("ValidationError.25", this.id));
        }
        if (it != null && it.requiresXMLGenerator()) {
            if (this.sqlMapGeneratorConfiguration == null) {
                errors.add(Messages.getString("ValidationError.9", this.id));
            } else {
                this.sqlMapGeneratorConfiguration.validate(errors, this.id);
            }
        }
        if (this.tableConfigurations.isEmpty()) {
            errors.add(Messages.getString("ValidationError.3", this.id));
        } else {
            for (int i = 0; i < this.tableConfigurations.size(); ++i) {
                TableConfiguration tc = this.tableConfigurations.get(i);
                tc.validate(errors, i);
            }
        }
        for (PluginConfiguration pluginConfiguration : this.pluginConfigurations) {
            pluginConfiguration.validate(errors, this.id);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setJavaClientGeneratorConfiguration(JavaClientGeneratorConfiguration javaClientGeneratorConfiguration) {
        this.javaClientGeneratorConfiguration = javaClientGeneratorConfiguration;
    }

    public void setJavaModelGeneratorConfiguration(JavaModelGeneratorConfiguration javaModelGeneratorConfiguration) {
        this.javaModelGeneratorConfiguration = javaModelGeneratorConfiguration;
    }

    public void setJavaTypeResolverConfiguration(JavaTypeResolverConfiguration javaTypeResolverConfiguration) {
        this.javaTypeResolverConfiguration = javaTypeResolverConfiguration;
    }

    public void setJdbcConnectionConfiguration(JDBCConnectionConfiguration jdbcConnectionConfiguration) {
        this.jdbcConnectionConfiguration = jdbcConnectionConfiguration;
    }

    public void setSqlMapGeneratorConfiguration(SqlMapGeneratorConfiguration sqlMapGeneratorConfiguration) {
        this.sqlMapGeneratorConfiguration = sqlMapGeneratorConfiguration;
    }

    public ModelType getDefaultModelType() {
        return this.defaultModelType;
    }

    public List<TableConfiguration> getTableConfigurations() {
        return this.tableConfigurations;
    }

    public String getBeginningDelimiter() {
        return this.beginningDelimiter;
    }

    public String getEndingDelimiter() {
        return this.endingDelimiter;
    }

    @Override
    public void addProperty(String name, String value) {
        super.addProperty(name, value);
        if ("beginningDelimiter".equals(name)) {
            this.beginningDelimiter = value;
        } else if ("endingDelimiter".equals(name)) {
            this.endingDelimiter = value;
        } else if ("autoDelimitKeywords".equals(name) && StringUtility.stringHasValue(value)) {
            this.autoDelimitKeywords = StringUtility.isTrue(value);
        } else if ("targetJava8".equals(name) && StringUtility.stringHasValue(value)) {
            this.isJava8Targeted = StringUtility.isTrue(value);
        }
    }

    public CommentGenerator getCommentGenerator() {
        if (this.commentGenerator == null) {
            this.commentGenerator = ObjectFactory.createCommentGenerator(this);
        }
        return this.commentGenerator;
    }

    public JavaFormatter getJavaFormatter() {
        if (this.javaFormatter == null) {
            this.javaFormatter = ObjectFactory.createJavaFormatter(this);
        }
        return this.javaFormatter;
    }

    public KotlinFormatter getKotlinFormatter() {
        if (this.kotlinFormatter == null) {
            this.kotlinFormatter = ObjectFactory.createKotlinFormatter(this);
        }
        return this.kotlinFormatter;
    }

    public XmlFormatter getXmlFormatter() {
        if (this.xmlFormatter == null) {
            this.xmlFormatter = ObjectFactory.createXmlFormatter(this);
        }
        return this.xmlFormatter;
    }

    public CommentGeneratorConfiguration getCommentGeneratorConfiguration() {
        return this.commentGeneratorConfiguration;
    }

    public void setCommentGeneratorConfiguration(CommentGeneratorConfiguration commentGeneratorConfiguration) {
        this.commentGeneratorConfiguration = commentGeneratorConfiguration;
    }

    public Plugin getPlugins() {
        return this.pluginAggregator;
    }

    public String getTargetRuntime() {
        return this.targetRuntime;
    }

    public void setTargetRuntime(String targetRuntime) {
        this.targetRuntime = targetRuntime;
    }

    public String getIntrospectedColumnImpl() {
        return this.introspectedColumnImpl;
    }

    public void setIntrospectedColumnImpl(String introspectedColumnImpl) {
        this.introspectedColumnImpl = introspectedColumnImpl;
    }

    public int getIntrospectionSteps() {
        int steps = 0;
        ++steps;
        return steps += this.tableConfigurations.size() * 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void introspectTables(ProgressCallback callback, List<String> warnings, Set<String> fullyQualifiedTableNames) throws SQLException, InterruptedException {
        this.introspectedTables = new ArrayList<IntrospectedTable>();
        JavaTypeResolver javaTypeResolver = ObjectFactory.createJavaTypeResolver(this, warnings);
        Connection connection = null;
        try {
            callback.startTask(Messages.getString("Progress.0"));
            connection = this.getConnection();
            DatabaseIntrospector databaseIntrospector = new DatabaseIntrospector(this, connection.getMetaData(), javaTypeResolver, warnings);
            for (TableConfiguration tc : this.tableConfigurations) {
                String tableName = StringUtility.composeFullyQualifiedTableName(tc.getCatalog(), tc.getSchema(), tc.getTableName(), '.');
                if (fullyQualifiedTableNames != null && !fullyQualifiedTableNames.isEmpty() && !fullyQualifiedTableNames.contains(tableName)) continue;
                if (!tc.areAnyStatementsEnabled()) {
                    warnings.add(Messages.getString("Warning.0", tableName));
                    continue;
                }
                callback.startTask(Messages.getString("Progress.1", tableName));
                List<IntrospectedTable> tables = databaseIntrospector.introspectTables(tc);
                if (tables != null) {
                    this.introspectedTables.addAll(tables);
                }
                callback.checkCancel();
            }
            this.closeConnection(connection);
        }
        catch (Throwable throwable) {
            this.closeConnection(connection);
            throw throwable;
        }
    }

    public int getGenerationSteps() {
        int steps = 0;
        if (this.introspectedTables != null) {
            for (IntrospectedTable introspectedTable : this.introspectedTables) {
                steps += introspectedTable.getGenerationSteps();
            }
        }
        return steps;
    }

    public void generateFiles(ProgressCallback callback, List<GeneratedJavaFile> generatedJavaFiles, List<GeneratedXmlFile> generatedXmlFiles, List<GeneratedKotlinFile> generatedKotlinFiles, List<String> warnings) throws InterruptedException {
        this.pluginAggregator = new PluginAggregator();
        for (PluginConfiguration pluginConfiguration : this.pluginConfigurations) {
            Plugin plugin = ObjectFactory.createPlugin(this, pluginConfiguration);
            if (plugin.validate(warnings)) {
                this.pluginAggregator.addPlugin(plugin);
                continue;
            }
            warnings.add(Messages.getString("Warning.24", pluginConfiguration.getConfigurationType(), this.id));
        }
        if (this.introspectedTables != null) {
            for (IntrospectedTable introspectedTable : this.introspectedTables) {
                callback.checkCancel();
                introspectedTable.initialize();
                introspectedTable.calculateGenerators(warnings, callback);
                generatedJavaFiles.addAll(introspectedTable.getGeneratedJavaFiles());
                generatedXmlFiles.addAll(introspectedTable.getGeneratedXmlFiles());
                generatedKotlinFiles.addAll(introspectedTable.getGeneratedKotlinFiles());
                generatedJavaFiles.addAll(this.pluginAggregator.contextGenerateAdditionalJavaFiles(introspectedTable));
                generatedXmlFiles.addAll(this.pluginAggregator.contextGenerateAdditionalXmlFiles(introspectedTable));
                generatedKotlinFiles.addAll(this.pluginAggregator.contextGenerateAdditionalKotlinFiles(introspectedTable));
            }
        }
        generatedJavaFiles.addAll(this.pluginAggregator.contextGenerateAdditionalJavaFiles());
        generatedXmlFiles.addAll(this.pluginAggregator.contextGenerateAdditionalXmlFiles());
        generatedKotlinFiles.addAll(this.pluginAggregator.contextGenerateAdditionalKotlinFiles());
    }

    private Connection getConnection() throws SQLException {
        ConnectionFactory connectionFactory = this.jdbcConnectionConfiguration != null ? new JDBCConnectionFactory(this.jdbcConnectionConfiguration) : ObjectFactory.createConnectionFactory(this);
        return connectionFactory.getConnection();
    }

    private void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public boolean autoDelimitKeywords() {
        return this.autoDelimitKeywords != null && this.autoDelimitKeywords != false;
    }

    public ConnectionFactoryConfiguration getConnectionFactoryConfiguration() {
        return this.connectionFactoryConfiguration;
    }

    public void setConnectionFactoryConfiguration(ConnectionFactoryConfiguration connectionFactoryConfiguration) {
        this.connectionFactoryConfiguration = connectionFactoryConfiguration;
    }

    public boolean isJava8Targeted() {
        return this.isJava8Targeted;
    }

    public void setJava8Targeted(boolean isJava8Targeted) {
        this.isJava8Targeted = isJava8Targeted;
    }
}

