/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.config;

import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.exception.InvalidConfigurationException;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public class Configuration {
    private List<Context> contexts = new ArrayList<Context>();
    private List<String> classPathEntries = new ArrayList<String>();

    public void addClasspathEntry(String entry) {
        this.classPathEntries.add(entry);
    }

    public List<String> getClassPathEntries() {
        return this.classPathEntries;
    }

    public void validate() throws InvalidConfigurationException {
        ArrayList<String> errors = new ArrayList<String>();
        for (String classPathEntry : this.classPathEntries) {
            if (StringUtility.stringHasValue(classPathEntry)) continue;
            errors.add(Messages.getString("ValidationError.19"));
            break;
        }
        if (this.contexts.isEmpty()) {
            errors.add(Messages.getString("ValidationError.11"));
        } else {
            for (Context context : this.contexts) {
                context.validate(errors);
            }
        }
        if (!errors.isEmpty()) {
            throw new InvalidConfigurationException(errors);
        }
    }

    public List<Context> getContexts() {
        return this.contexts;
    }

    public void addContext(Context context) {
        this.contexts.add(context);
    }

    public Context getContext(String id) {
        for (Context context : this.contexts) {
            if (!id.equals(context.getId())) continue;
            return context;
        }
        return null;
    }
}

