/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.codegen.mybatis3;

import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.GeneratedKotlinFile;
import org.mybatis.generator.api.GeneratedXmlFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.ProgressCallback;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.kotlin.KotlinFile;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.codegen.AbstractGenerator;
import org.mybatis.generator.codegen.AbstractJavaClientGenerator;
import org.mybatis.generator.codegen.AbstractJavaGenerator;
import org.mybatis.generator.codegen.AbstractKotlinGenerator;
import org.mybatis.generator.codegen.AbstractXmlGenerator;
import org.mybatis.generator.codegen.mybatis3.javamapper.AnnotatedClientGenerator;
import org.mybatis.generator.codegen.mybatis3.javamapper.JavaMapperGenerator;
import org.mybatis.generator.codegen.mybatis3.javamapper.MixedClientGenerator;
import org.mybatis.generator.codegen.mybatis3.model.BaseRecordGenerator;
import org.mybatis.generator.codegen.mybatis3.model.ExampleGenerator;
import org.mybatis.generator.codegen.mybatis3.model.PrimaryKeyGenerator;
import org.mybatis.generator.codegen.mybatis3.model.RecordWithBLOBsGenerator;
import org.mybatis.generator.codegen.mybatis3.xmlmapper.XMLMapperGenerator;
import org.mybatis.generator.internal.ObjectFactory;
import org.mybatis.generator.internal.util.StringUtility;

public class IntrospectedTableMyBatis3Impl
extends IntrospectedTable {
    protected List<AbstractJavaGenerator> javaGenerators = new ArrayList<AbstractJavaGenerator>();
    protected List<AbstractKotlinGenerator> kotlinGenerators = new ArrayList<AbstractKotlinGenerator>();
    protected AbstractXmlGenerator xmlMapperGenerator;

    public IntrospectedTableMyBatis3Impl() {
        super(IntrospectedTable.TargetRuntime.MYBATIS3);
    }

    @Override
    public void calculateGenerators(List<String> warnings, ProgressCallback progressCallback) {
        this.calculateJavaModelGenerators(warnings, progressCallback);
        AbstractJavaClientGenerator javaClientGenerator = this.calculateClientGenerators(warnings, progressCallback);
        this.calculateXmlMapperGenerator(javaClientGenerator, warnings, progressCallback);
    }

    protected void calculateXmlMapperGenerator(AbstractJavaClientGenerator javaClientGenerator, List<String> warnings, ProgressCallback progressCallback) {
        if (javaClientGenerator == null) {
            if (this.context.getSqlMapGeneratorConfiguration() != null) {
                this.xmlMapperGenerator = new XMLMapperGenerator();
            }
        } else {
            this.xmlMapperGenerator = javaClientGenerator.getMatchedXMLGenerator();
        }
        this.initializeAbstractGenerator(this.xmlMapperGenerator, warnings, progressCallback);
    }

    protected AbstractJavaClientGenerator calculateClientGenerators(List<String> warnings, ProgressCallback progressCallback) {
        if (!this.rules.generateJavaClient()) {
            return null;
        }
        AbstractJavaClientGenerator javaGenerator = this.createJavaClientGenerator();
        if (javaGenerator == null) {
            return null;
        }
        this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
        this.javaGenerators.add(javaGenerator);
        return javaGenerator;
    }

    protected AbstractJavaClientGenerator createJavaClientGenerator() {
        if (this.context.getJavaClientGeneratorConfiguration() == null) {
            return null;
        }
        String type = this.context.getJavaClientGeneratorConfiguration().getConfigurationType();
        AbstractJavaClientGenerator javaGenerator = "XMLMAPPER".equalsIgnoreCase(type) ? new JavaMapperGenerator(this.getClientProject()) : ("MIXEDMAPPER".equalsIgnoreCase(type) ? new MixedClientGenerator(this.getClientProject()) : ("ANNOTATEDMAPPER".equalsIgnoreCase(type) ? new AnnotatedClientGenerator(this.getClientProject()) : ("MAPPER".equalsIgnoreCase(type) ? new JavaMapperGenerator(this.getClientProject()) : (AbstractJavaClientGenerator)ObjectFactory.createInternalObject(type))));
        return javaGenerator;
    }

    protected void calculateJavaModelGenerators(List<String> warnings, ProgressCallback progressCallback) {
        AbstractJavaGenerator javaGenerator;
        if (this.getRules().generateExampleClass()) {
            javaGenerator = new ExampleGenerator(this.getExampleProject());
            this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
            this.javaGenerators.add(javaGenerator);
        }
        if (this.getRules().generatePrimaryKeyClass()) {
            javaGenerator = new PrimaryKeyGenerator(this.getModelProject());
            this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
            this.javaGenerators.add(javaGenerator);
        }
        if (this.getRules().generateBaseRecordClass()) {
            javaGenerator = new BaseRecordGenerator(this.getModelProject());
            this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
            this.javaGenerators.add(javaGenerator);
        }
        if (this.getRules().generateRecordWithBLOBsClass()) {
            javaGenerator = new RecordWithBLOBsGenerator(this.getModelProject());
            this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
            this.javaGenerators.add(javaGenerator);
        }
    }

    protected void initializeAbstractGenerator(AbstractGenerator abstractGenerator, List<String> warnings, ProgressCallback progressCallback) {
        if (abstractGenerator == null) {
            return;
        }
        abstractGenerator.setContext(this.context);
        abstractGenerator.setIntrospectedTable(this);
        abstractGenerator.setProgressCallback(progressCallback);
        abstractGenerator.setWarnings(warnings);
    }

    @Override
    public List<GeneratedJavaFile> getGeneratedJavaFiles() {
        ArrayList<GeneratedJavaFile> answer = new ArrayList<GeneratedJavaFile>();
        for (AbstractJavaGenerator javaGenerator : this.javaGenerators) {
            List<CompilationUnit> compilationUnits = javaGenerator.getCompilationUnits();
            for (CompilationUnit compilationUnit : compilationUnits) {
                GeneratedJavaFile gjf = new GeneratedJavaFile(compilationUnit, javaGenerator.getProject(), this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
                answer.add(gjf);
            }
        }
        return answer;
    }

    @Override
    public List<GeneratedKotlinFile> getGeneratedKotlinFiles() {
        ArrayList<GeneratedKotlinFile> answer = new ArrayList<GeneratedKotlinFile>();
        for (AbstractKotlinGenerator kotlinGenerator : this.kotlinGenerators) {
            List<KotlinFile> kotlinFiles = kotlinGenerator.getKotlinFiles();
            for (KotlinFile kotlinFile : kotlinFiles) {
                GeneratedKotlinFile gjf = new GeneratedKotlinFile(kotlinFile, kotlinGenerator.getProject(), this.context.getProperty("kotlinFileEncoding"), this.context.getKotlinFormatter());
                answer.add(gjf);
            }
        }
        return answer;
    }

    protected String getClientProject() {
        return this.context.getJavaClientGeneratorConfiguration().getTargetProject();
    }

    protected String getModelProject() {
        return this.context.getJavaModelGeneratorConfiguration().getTargetProject();
    }

    protected String getExampleProject() {
        String project = this.context.getJavaModelGeneratorConfiguration().getProperty("exampleTargetProject");
        if (StringUtility.stringHasValue(project)) {
            return project;
        }
        return this.getModelProject();
    }

    @Override
    public List<GeneratedXmlFile> getGeneratedXmlFiles() {
        ArrayList<GeneratedXmlFile> answer = new ArrayList<GeneratedXmlFile>();
        if (this.xmlMapperGenerator != null) {
            Document document = this.xmlMapperGenerator.getDocument();
            GeneratedXmlFile gxf = new GeneratedXmlFile(document, this.getMyBatis3XmlMapperFileName(), this.getMyBatis3XmlMapperPackage(), this.context.getSqlMapGeneratorConfiguration().getTargetProject(), true, this.context.getXmlFormatter());
            if (this.context.getPlugins().sqlMapGenerated(gxf, this)) {
                answer.add(gxf);
            }
        }
        return answer;
    }

    @Override
    public int getGenerationSteps() {
        return this.javaGenerators.size() + (this.xmlMapperGenerator == null ? 0 : 1);
    }

    @Override
    public boolean requiresXMLGenerator() {
        AbstractJavaClientGenerator javaClientGenerator = this.createJavaClientGenerator();
        if (javaClientGenerator == null) {
            return false;
        }
        return javaClientGenerator.requiresXMLGenerator();
    }
}

