/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.xml.render;

import java.util.stream.Stream;
import org.mybatis.generator.api.dom.xml.ElementVisitor;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.VisitableElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.api.dom.xml.render.AttributeRenderer;
import org.mybatis.generator.internal.util.CustomCollectors;

public class ElementRenderer
implements ElementVisitor<Stream<String>> {
    private AttributeRenderer attributeRenderer = new AttributeRenderer();

    @Override
    public Stream<String> visit(TextElement element) {
        return Stream.of(element.getContent());
    }

    @Override
    public Stream<String> visit(XmlElement element) {
        if (element.hasChildren()) {
            return this.renderWithChildren(element);
        }
        return this.renderWithoutChildren(element);
    }

    private Stream<String> renderWithoutChildren(XmlElement element) {
        return Stream.of("<" + element.getName() + this.renderAttributes(element) + " />");
    }

    public Stream<String> renderWithChildren(XmlElement element) {
        return Stream.of(this.renderOpen(element), this.renderChildren(element), this.renderClose(element)).flatMap(s -> s);
    }

    private String renderAttributes(XmlElement element) {
        return element.getAttributes().stream().sorted((a1, a2) -> a1.getName().compareTo(a2.getName())).map(this.attributeRenderer::render).collect(CustomCollectors.joining(" ", " ", ""));
    }

    private Stream<String> renderOpen(XmlElement element) {
        return Stream.of("<" + element.getName() + this.renderAttributes(element) + ">");
    }

    private Stream<String> renderChildren(XmlElement element) {
        return element.getElements().stream().flatMap(this::renderChild).map(this::indent);
    }

    private Stream<String> renderChild(VisitableElement child) {
        return child.accept(this);
    }

    private String indent(String s) {
        return "  " + s;
    }

    private Stream<String> renderClose(XmlElement element) {
        return Stream.of("</" + element.getName() + ">");
    }
}

