/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.kotlin.render;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.mybatis.generator.api.dom.java.render.RenderingUtilities;
import org.mybatis.generator.api.dom.kotlin.KotlinNamedItem;
import org.mybatis.generator.api.dom.kotlin.KotlinProperty;
import org.mybatis.generator.api.dom.kotlin.KotlinType;
import org.mybatis.generator.api.dom.kotlin.render.KotlinNamedItemRenderer;
import org.mybatis.generator.api.dom.kotlin.render.KotlinPropertyRenderer;
import org.mybatis.generator.api.dom.kotlin.render.KotlinRenderingUtilities;
import org.mybatis.generator.internal.util.CustomCollectors;

public class KotlinTypeRenderer {
    public List<String> render(KotlinType kotlinType) {
        List<String> answer = new ArrayList<String>();
        KotlinNamedItemRenderer renderer = new KotlinNamedItemRenderer();
        answer.addAll(kotlinType.getAnnotations());
        String line = KotlinRenderingUtilities.renderModifiers(kotlinType.getModifiers()) + kotlinType.getType().getValue() + " " + kotlinType.getName();
        line = line + kotlinType.getSuperTypes().stream().collect(CustomCollectors.joining(", ", " : ", ""));
        if (kotlinType.getNamedItems().isEmpty()) {
            if (kotlinType.getConstructorProperties().isEmpty()) {
                answer.add(line);
            } else {
                answer.add(line + "(");
                answer.addAll(this.renderConstructorItems(kotlinType));
                answer.add(")");
            }
        } else if (kotlinType.getConstructorProperties().isEmpty()) {
            answer.add(line + " {");
        } else {
            answer.add(line + "(");
            answer.addAll(this.renderConstructorItems(kotlinType));
            answer.add(") {");
        }
        for (KotlinNamedItem namedItem : kotlinType.getNamedItems()) {
            answer.addAll(renderer.render(namedItem).stream().map(KotlinRenderingUtilities::kotlinIndent).collect(Collectors.toList()));
            answer.add("");
        }
        answer = RenderingUtilities.removeLastEmptyLine(answer);
        if (!kotlinType.getNamedItems().isEmpty()) {
            answer.add("}");
        }
        return answer;
    }

    private List<String> renderConstructorItems(KotlinType kotlinType) {
        ArrayList<String> lines = new ArrayList<String>();
        KotlinPropertyRenderer renderer = new KotlinPropertyRenderer();
        Iterator<KotlinProperty> iter = kotlinType.getConstructorProperties().iterator();
        while (iter.hasNext()) {
            lines.addAll(renderer.render(iter.next()).stream().map(KotlinRenderingUtilities::kotlinIndent).collect(Collectors.toList()));
            if (!iter.hasNext()) continue;
            lines.set(lines.size() - 1, (String)lines.get(lines.size() - 1) + ",");
        }
        return lines;
    }
}

