/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.kotlin;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mybatis.generator.api.dom.kotlin.KotlinArg;
import org.mybatis.generator.api.dom.kotlin.KotlinNamedItem;
import org.mybatis.generator.api.dom.kotlin.KotlinNamedItemVisitor;

public class KotlinFunction
extends KotlinNamedItem {
    private List<KotlinArg> arguments = new ArrayList<KotlinArg>();
    private List<String> codeLines = new ArrayList<String>();
    private String explicitReturnType;
    private boolean isOneLineFunction;

    private KotlinFunction(Builder builder) {
        super(builder);
        this.arguments.addAll(builder.arguments);
        this.codeLines.addAll(builder.codeLines);
        this.explicitReturnType = builder.explicitReturnType;
        this.isOneLineFunction = builder.isOneLineFunction;
    }

    public void addArgument(KotlinArg argument) {
        this.arguments.add(argument);
    }

    public List<KotlinArg> getArguments() {
        return this.arguments;
    }

    public void addCodeLine(String codeLine) {
        this.codeLines.add(codeLine);
    }

    public void addCodeLines(List<String> codeLines) {
        this.codeLines.addAll(codeLines);
    }

    public List<String> getCodeLines() {
        return this.codeLines;
    }

    public Optional<String> getExplicitReturnType() {
        return Optional.ofNullable(this.explicitReturnType);
    }

    public boolean isOneLineFunction() {
        return this.isOneLineFunction;
    }

    @Override
    public <R> R accept(KotlinNamedItemVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public static Builder newOneLineFunction(String name) {
        return new Builder(name, true);
    }

    public static Builder newMultiLineFunction(String name) {
        return new Builder(name, false);
    }

    public static class Builder
    extends KotlinNamedItem.AbstractBuilder<Builder> {
        private boolean isOneLineFunction;
        private List<KotlinArg> arguments = new ArrayList<KotlinArg>();
        private List<String> codeLines = new ArrayList<String>();
        private String explicitReturnType;

        private Builder(String name, boolean isOneLineFunction) {
            super(name);
            this.isOneLineFunction = isOneLineFunction;
        }

        public Builder withArgument(KotlinArg argument) {
            this.arguments.add(argument);
            return this;
        }

        public Builder withCodeLine(String codeLine) {
            this.codeLines.add(codeLine);
            return this;
        }

        public Builder withExplicitReturnType(String explicitReturnType) {
            this.explicitReturnType = explicitReturnType;
            return this;
        }

        @Override
        public Builder getThis() {
            return this;
        }

        public KotlinFunction build() {
            return new KotlinFunction(this);
        }
    }
}

