/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.mybatis.generator.api.dom.kotlin.KotlinNamedItem;

public class KotlinFile {
    private String fileName;
    private List<String> fileCommentLines = new ArrayList<String>();
    private Set<String> imports = new TreeSet<String>();
    private String packageDefinition;
    private List<KotlinNamedItem> namedItems = new ArrayList<KotlinNamedItem>();

    public KotlinFile(String fileName) {
        Objects.requireNonNull(fileName);
        this.fileName = fileName.endsWith(".kt") ? fileName : fileName + ".kt";
    }

    public String getFileName() {
        return this.fileName;
    }

    public List<String> getFileCommentLines() {
        return this.fileCommentLines;
    }

    public void addFileCommentLine(String fileComentLine) {
        this.fileCommentLines.add(fileComentLine);
    }

    public Set<String> getImports() {
        return this.imports;
    }

    public void addImport(String i) {
        this.imports.add(i);
    }

    public void addImports(Collection<String> imports) {
        this.imports.addAll(imports);
    }

    public Optional<String> getPackage() {
        return Optional.ofNullable(this.packageDefinition);
    }

    public void setPackage(String p) {
        this.packageDefinition = p;
    }

    public void addNamedItem(KotlinNamedItem namedItem) {
        this.namedItems.add(namedItem);
    }

    public List<KotlinNamedItem> getNamedItems() {
        return this.namedItems;
    }
}

