/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public class FullyQualifiedKotlinType {
    private static final Set<String> AUTOMATIC_KOTLIN_PACKAGES = new HashSet<String>();
    private String packageName;
    private List<FullyQualifiedKotlinType> typeArguments = new ArrayList<FullyQualifiedKotlinType>();
    private String shortNameWithoutTypeArguments;
    private boolean isExplicitlyImported;

    public FullyQualifiedKotlinType(String fullTypeSpecification) {
        this.parse(Objects.requireNonNull(fullTypeSpecification).trim());
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getShortNameWithoutTypeArguments() {
        return this.shortNameWithoutTypeArguments;
    }

    public String getShortNameWithTypeArguments() {
        if (this.typeArguments.isEmpty()) {
            return this.shortNameWithoutTypeArguments;
        }
        return this.typeArguments.stream().map(FullyQualifiedKotlinType::getShortNameWithTypeArguments).collect(Collectors.joining(", ", this.shortNameWithoutTypeArguments + "<", ">"));
    }

    public List<FullyQualifiedKotlinType> getTypeArguments() {
        return this.typeArguments;
    }

    public void addTypeArgument(FullyQualifiedKotlinType typeArgument) {
        this.typeArguments.add(typeArgument);
    }

    public Set<String> getImportList() {
        Stream<Object> thisImport = this.isExplicitlyImported ? Stream.of(this.packageName + "." + this.shortNameWithoutTypeArguments) : Stream.empty();
        Stream ss = this.typeArguments.stream().map(FullyQualifiedKotlinType::getImportList).flatMap(Collection::stream);
        return Stream.of(thisImport, ss).flatMap(Function.identity()).collect(Collectors.toSet());
    }

    private void parse(String fullTypeSpecification) {
        int index = fullTypeSpecification.indexOf(60);
        if (index == -1) {
            this.simpleParse(fullTypeSpecification);
        } else {
            this.simpleParse(fullTypeSpecification.substring(0, index));
            int endIndex = fullTypeSpecification.lastIndexOf(62);
            if (endIndex == -1) {
                throw new RuntimeException(Messages.getString("RuntimeError.22", fullTypeSpecification));
            }
            this.genericParse(fullTypeSpecification.substring(index, endIndex + 1));
        }
    }

    private void simpleParse(String typeSpecification) {
        String baseQualifiedName = typeSpecification.trim();
        if (baseQualifiedName.contains(".")) {
            this.packageName = FullyQualifiedKotlinType.getPackage(baseQualifiedName);
            this.shortNameWithoutTypeArguments = baseQualifiedName.substring(this.packageName.length() + 1);
            this.isExplicitlyImported = !AUTOMATIC_KOTLIN_PACKAGES.contains(this.packageName);
        } else {
            this.shortNameWithoutTypeArguments = baseQualifiedName;
            this.isExplicitlyImported = false;
            this.packageName = "";
        }
    }

    private void genericParse(String genericSpecification) {
        int lastIndex = genericSpecification.lastIndexOf(62);
        if (lastIndex == -1) {
            throw new RuntimeException(Messages.getString("RuntimeError.22", genericSpecification));
        }
        String argumentString = genericSpecification.substring(1, lastIndex);
        StringTokenizer st = new StringTokenizer(argumentString, ",<>", true);
        int openCount = 0;
        StringBuilder sb = new StringBuilder();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("<".equals(token)) {
                sb.append(token);
                ++openCount;
                continue;
            }
            if (">".equals(token)) {
                sb.append(token);
                --openCount;
                continue;
            }
            if (",".equals(token)) {
                if (openCount == 0) {
                    this.typeArguments.add(new FullyQualifiedKotlinType(sb.toString()));
                    sb.setLength(0);
                    continue;
                }
                sb.append(token);
                continue;
            }
            sb.append(token);
        }
        if (openCount != 0) {
            throw new RuntimeException(Messages.getString("RuntimeError.22", genericSpecification));
        }
        String finalType = sb.toString();
        if (StringUtility.stringHasValue(finalType)) {
            this.typeArguments.add(new FullyQualifiedKotlinType(finalType));
        }
    }

    private static String getPackage(String baseQualifiedName) {
        int index = baseQualifiedName.lastIndexOf(46);
        return baseQualifiedName.substring(0, index);
    }

    static {
        AUTOMATIC_KOTLIN_PACKAGES.add("kotlin");
        AUTOMATIC_KOTLIN_PACKAGES.add("kotlin.collections");
    }
}

