/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.java;

import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.render.ParameterRenderer;

public class Parameter {
    private String name;
    private FullyQualifiedJavaType type;
    private boolean isVarargs;
    private List<String> annotations = new ArrayList<String>();

    public Parameter(FullyQualifiedJavaType type, String name, boolean isVarargs) {
        this.name = name;
        this.type = type;
        this.isVarargs = isVarargs;
    }

    public Parameter(FullyQualifiedJavaType type, String name) {
        this(type, name, false);
    }

    public Parameter(FullyQualifiedJavaType type, String name, String annotation) {
        this(type, name, false);
        this.addAnnotation(annotation);
    }

    public Parameter(FullyQualifiedJavaType type, String name, String annotation, boolean isVarargs) {
        this(type, name, isVarargs);
        this.addAnnotation(annotation);
    }

    public String getName() {
        return this.name;
    }

    public FullyQualifiedJavaType getType() {
        return this.type;
    }

    public List<String> getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(String annotation) {
        this.annotations.add(annotation);
    }

    public String toString() {
        return new ParameterRenderer().render(this, null);
    }

    public boolean isVarargs() {
        return this.isVarargs;
    }
}

