/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.java;

import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.dom.java.JavaVisibility;

public abstract class JavaElement {
    private List<String> javaDocLines = new ArrayList<String>();
    private JavaVisibility visibility = JavaVisibility.DEFAULT;
    private boolean isStatic;
    private List<String> annotations = new ArrayList<String>();

    public JavaElement() {
    }

    public JavaElement(JavaElement original) {
        this.annotations.addAll(original.annotations);
        this.isStatic = original.isStatic;
        this.javaDocLines.addAll(original.javaDocLines);
        this.visibility = original.visibility;
    }

    public List<String> getJavaDocLines() {
        return this.javaDocLines;
    }

    public void addJavaDocLine(String javaDocLine) {
        this.javaDocLines.add(javaDocLine);
    }

    public List<String> getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(String annotation) {
        this.annotations.add(annotation);
    }

    public JavaVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(JavaVisibility visibility) {
        this.visibility = visibility;
    }

    public void addSuppressTypeWarningsAnnotation() {
        this.addAnnotation("@SuppressWarnings(\"unchecked\")");
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }
}

