/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.java;

import java.util.stream.Collectors;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;

public class JavaDomUtils {
    private JavaDomUtils() {
    }

    public static String calculateTypeName(CompilationUnit compilationUnit, FullyQualifiedJavaType fqjt) {
        if (fqjt.isArray()) {
            String fqn = fqjt.getFullyQualifiedName();
            String typeName = JavaDomUtils.calculateTypeName(compilationUnit, new FullyQualifiedJavaType(fqn.substring(0, fqn.indexOf(91))));
            return typeName + fqn.substring(fqn.indexOf(91));
        }
        if (!fqjt.getTypeArguments().isEmpty()) {
            return JavaDomUtils.calculateParameterizedTypeName(compilationUnit, fqjt);
        }
        if (compilationUnit == null || JavaDomUtils.typeDoesNotRequireImport(fqjt) || JavaDomUtils.typeIsInSamePackage(compilationUnit, fqjt) || JavaDomUtils.typeIsAlreadyImported(compilationUnit, fqjt)) {
            return fqjt.getShortName();
        }
        return fqjt.getFullyQualifiedName();
    }

    private static String calculateParameterizedTypeName(CompilationUnit compilationUnit, FullyQualifiedJavaType fqjt) {
        String baseTypeName = JavaDomUtils.calculateTypeName(compilationUnit, new FullyQualifiedJavaType(fqjt.getFullyQualifiedNameWithoutTypeParameters()));
        return fqjt.getTypeArguments().stream().map(t -> JavaDomUtils.calculateTypeName(compilationUnit, t)).collect(Collectors.joining(", ", baseTypeName + "<", ">"));
    }

    private static boolean typeDoesNotRequireImport(FullyQualifiedJavaType fullyQualifiedJavaType) {
        return fullyQualifiedJavaType.isPrimitive() || !fullyQualifiedJavaType.isExplicitlyImported();
    }

    private static boolean typeIsInSamePackage(CompilationUnit compilationUnit, FullyQualifiedJavaType fullyQualifiedJavaType) {
        return fullyQualifiedJavaType.getPackageName().equals(compilationUnit.getType().getPackageName());
    }

    private static boolean typeIsAlreadyImported(CompilationUnit compilationUnit, FullyQualifiedJavaType fullyQualifiedJavaType) {
        String name = fullyQualifiedJavaType.getFullyQualifiedNameWithoutTypeParameters();
        return compilationUnit.getImportedTypes().stream().anyMatch(e -> e.getImportList().contains(name));
    }
}

