/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.VerboseProgressCallback;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.exception.InvalidConfigurationException;
import org.mybatis.generator.exception.XMLParserException;
import org.mybatis.generator.internal.DefaultShellCallback;
import org.mybatis.generator.internal.util.messages.Messages;
import org.mybatis.generator.logging.LogFactory;

public class ShellRunner {
    private static final String CONFIG_FILE = "-configfile";
    private static final String OVERWRITE = "-overwrite";
    private static final String CONTEXT_IDS = "-contextids";
    private static final String TABLES = "-tables";
    private static final String VERBOSE = "-verbose";
    private static final String FORCE_JAVA_LOGGING = "-forceJavaLogging";
    private static final String HELP_1 = "-?";
    private static final String HELP_2 = "-h";

    public static void main(String[] args) {
        if (args.length == 0) {
            ShellRunner.usage();
            System.exit(0);
            return;
        }
        Map<String, String> arguments = ShellRunner.parseCommandLine(args);
        if (arguments.containsKey(HELP_1)) {
            ShellRunner.usage();
            System.exit(0);
            return;
        }
        if (!arguments.containsKey(CONFIG_FILE)) {
            ShellRunner.writeLine(Messages.getString("RuntimeError.0"));
            return;
        }
        ArrayList<String> warnings = new ArrayList<String>();
        String configfile = arguments.get(CONFIG_FILE);
        File configurationFile = new File(configfile);
        if (!configurationFile.exists()) {
            ShellRunner.writeLine(Messages.getString("RuntimeError.1", configfile));
            return;
        }
        HashSet<String> fullyqualifiedTables = new HashSet<String>();
        if (arguments.containsKey(TABLES)) {
            StringTokenizer st = new StringTokenizer(arguments.get(TABLES), ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (s.length() <= 0) continue;
                fullyqualifiedTables.add(s);
            }
        }
        HashSet<String> contexts = new HashSet<String>();
        if (arguments.containsKey(CONTEXT_IDS)) {
            StringTokenizer st = new StringTokenizer(arguments.get(CONTEXT_IDS), ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (s.length() <= 0) continue;
                contexts.add(s);
            }
        }
        try {
            ConfigurationParser cp = new ConfigurationParser(warnings);
            Iterator<String> config = cp.parseConfiguration(configurationFile);
            DefaultShellCallback shellCallback = new DefaultShellCallback(arguments.containsKey(OVERWRITE));
            MyBatisGenerator myBatisGenerator = new MyBatisGenerator((Configuration)((Object)config), shellCallback, (List<String>)warnings);
            VerboseProgressCallback progressCallback = arguments.containsKey(VERBOSE) ? new VerboseProgressCallback() : null;
            myBatisGenerator.generate(progressCallback, contexts, fullyqualifiedTables);
        }
        catch (XMLParserException e) {
            ShellRunner.writeLine(Messages.getString("Progress.3"));
            ShellRunner.writeLine();
            for (String error : e.getErrors()) {
                ShellRunner.writeLine(error);
            }
            return;
        }
        catch (IOException | SQLException e) {
            e.printStackTrace(System.out);
            return;
        }
        catch (InvalidConfigurationException e) {
            ShellRunner.writeLine(Messages.getString("Progress.16"));
            for (String error : e.getErrors()) {
                ShellRunner.writeLine(error);
            }
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        for (String warning : warnings) {
            ShellRunner.writeLine(warning);
        }
        if (warnings.isEmpty()) {
            ShellRunner.writeLine(Messages.getString("Progress.4"));
        } else {
            ShellRunner.writeLine();
            ShellRunner.writeLine(Messages.getString("Progress.5"));
        }
    }

    private static void usage() {
        ShellRunner.writeLine(Messages.getString("Usage"));
    }

    private static void writeLine(String message) {
        System.out.println(message);
    }

    private static void writeLine() {
        System.out.println();
    }

    private static Map<String, String> parseCommandLine(String[] args) {
        ArrayList<String> errors = new ArrayList<String>();
        HashMap<String, String> arguments = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            if (CONFIG_FILE.equalsIgnoreCase(args[i])) {
                if (i + 1 < args.length) {
                    arguments.put(CONFIG_FILE, args[i + 1]);
                } else {
                    errors.add(Messages.getString("RuntimeError.19", CONFIG_FILE));
                }
                ++i;
                continue;
            }
            if (OVERWRITE.equalsIgnoreCase(args[i])) {
                arguments.put(OVERWRITE, "Y");
                continue;
            }
            if (VERBOSE.equalsIgnoreCase(args[i])) {
                arguments.put(VERBOSE, "Y");
                continue;
            }
            if (HELP_1.equalsIgnoreCase(args[i])) {
                arguments.put(HELP_1, "Y");
                continue;
            }
            if (HELP_2.equalsIgnoreCase(args[i])) {
                arguments.put(HELP_1, "Y");
                continue;
            }
            if (FORCE_JAVA_LOGGING.equalsIgnoreCase(args[i])) {
                LogFactory.forceJavaLogging();
                continue;
            }
            if (CONTEXT_IDS.equalsIgnoreCase(args[i])) {
                if (i + 1 < args.length) {
                    arguments.put(CONTEXT_IDS, args[i + 1]);
                } else {
                    errors.add(Messages.getString("RuntimeError.19", CONTEXT_IDS));
                }
                ++i;
                continue;
            }
            if (TABLES.equalsIgnoreCase(args[i])) {
                if (i + 1 < args.length) {
                    arguments.put(TABLES, args[i + 1]);
                } else {
                    errors.add(Messages.getString("RuntimeError.19", TABLES));
                }
                ++i;
                continue;
            }
            errors.add(Messages.getString("RuntimeError.20", args[i]));
        }
        if (!errors.isEmpty()) {
            for (String error : errors) {
                ShellRunner.writeLine(error);
            }
            System.exit(-1);
        }
        return arguments;
    }
}

