/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.cometd.AbstractTransport;
import org.mortbay.util.ajax.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONPTransport
extends AbstractTransport {
    int _responses = 0;
    PrintWriter _out;
    String jsonp = "jsonpcallback";
    boolean _commented;
    String _mimeType;

    public JSONPTransport() {
        this.setJSONCommented(false);
    }

    public JSONPTransport(boolean commented) {
        this.setJSONCommented(commented);
        this._commented = commented;
    }

    @Override
    public void send(Map<String, Object> reply) throws IOException {
        if (reply != null) {
            if (this._responses == 0) {
                HttpServletResponse response = this.getResponse();
                response.setContentType(this._mimeType);
                this._out = response.getWriter();
                if (this._commented) {
                    this._out.write("/*");
                }
                this._out.write(this.jsonp);
                this._out.write("([");
            } else {
                this._out.write(",\r\n");
            }
            String r = JSON.toString(reply);
            ++this._responses;
            this._out.write(r);
        }
    }

    @Override
    public void complete() throws IOException {
        HttpServletResponse response = this.getResponse();
        response.setStatus(200);
        if (this._responses == 0) {
            response.setContentLength(0);
        } else {
            if (this._commented) {
                this._out.write("])*/\r\n");
            } else {
                this._out.write("])\r\n");
            }
            this._out.flush();
        }
    }

    @Override
    public boolean keepAlive() throws IOException {
        return false;
    }

    public String getJsonp() {
        return this.jsonp;
    }

    public void setJsonp(String jsonp) {
        this.jsonp = jsonp;
    }

    public String toString() {
        return "JSONPTransport[jsonp=" + this.jsonp + "]";
    }

    @Override
    public boolean isJSONCommented() {
        return this._commented;
    }

    @Override
    public void setJSONCommented(boolean commented) {
        this._commented = commented;
        this._mimeType = commented ? "text/javascript-comment-filtered; charset=utf-8" : "text/javascript; charset=utf-8";
    }
}

