/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.model;

import java.lang.module.FindException;
import java.lang.module.ModuleFinder;
import java.nio.file.Path;

public class DependencyDescriptor {
    private final Path path;
    private final boolean optional;
    private final String originalModuleName;
    private final String assignedModuleName;

    public DependencyDescriptor(Path path, boolean optional, String assignedModuleName) {
        this.path = path;
        this.optional = optional;
        this.originalModuleName = DependencyDescriptor.getAutoModuleNameFromInputJar(path, assignedModuleName);
        if (this.originalModuleName == null) {
            throw new IllegalArgumentException("No assignedModuleName provided for jar with invalid module name: " + path);
        }
        this.assignedModuleName = assignedModuleName;
    }

    public static String getAutoModuleNameFromInputJar(Path path, String invalidModuleName) {
        try {
            return ModuleFinder.of(path).findAll().iterator().next().descriptor().name();
        }
        catch (FindException e) {
            if (e.getCause() != null && e.getCause().getMessage().contains("Invalid module name")) {
                return invalidModuleName;
            }
            throw e;
        }
    }

    public Path getPath() {
        return this.path;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getOriginalModuleName() {
        return this.originalModuleName;
    }

    public String getAssignedModuleName() {
        return this.assignedModuleName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.path.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyDescriptor other = (DependencyDescriptor)obj;
        return this.path.equals(other.path);
    }

    public String toString() {
        return "DependencyDescriptor [path=" + this.path + ", optional=" + this.optional + ", originalModuleName=" + this.originalModuleName + ", assignedModuleName=" + this.assignedModuleName + "]";
    }
}

