/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DependencePattern {
    private static final Pattern PATTERN = Pattern.compile("((.*)\\s+)?(.*?)");
    private final boolean inclusive;
    private final Pattern pattern;
    private final Set<String> modifiers;

    public static List<DependencePattern> parsePatterns(String patterns) {
        if (patterns == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(patterns.trim().split(";")).map(DependencePattern::parsePattern).collect(Collectors.toList());
    }

    public static DependencePattern parsePattern(String pattern) {
        Matcher matcher = PATTERN.matcher(pattern = pattern.trim());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid dependence pattern: " + pattern);
        }
        if (matcher.group(3) != null) {
            return new DependencePattern(matcher.group(3), matcher.group(2));
        }
        return new DependencePattern(matcher.group(2), null);
    }

    private DependencePattern(String pattern, String modifiers) {
        if (pattern.startsWith("!")) {
            pattern = pattern.substring(1);
            this.inclusive = false;
        } else {
            this.inclusive = true;
        }
        this.pattern = Pattern.compile(pattern.replace(".", "\\.").replace("*", ".*"));
        this.modifiers = modifiers == null ? Collections.emptySet() : Arrays.stream(modifiers.split("\\s")).map(String::trim).collect(Collectors.toSet());
    }

    public boolean matches(String packageName) {
        return this.pattern.matcher(packageName).matches();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Set<String> getModifiers() {
        return this.modifiers;
    }

    public boolean isMatchAll() {
        return ".*".equals(this.pattern.pattern());
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public String toString() {
        return "DependencePattern[pattern=" + this.pattern + ",modifiers=" + this.modifiers + "]";
    }
}

