/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.internal.shaded.javaparser.resolution.model;

import java.util.Optional;
import org.moditect.internal.shaded.javaparser.resolution.UnsolvedSymbolException;
import org.moditect.internal.shaded.javaparser.resolution.declarations.ResolvedDeclaration;

public class SymbolReference<S extends ResolvedDeclaration> {
    private final S correspondingDeclaration;

    public static <S extends ResolvedDeclaration, S2 extends S> SymbolReference<S> solved(S2 symbolDeclaration) {
        return new SymbolReference<S2>(symbolDeclaration);
    }

    public static <S extends ResolvedDeclaration> SymbolReference<S> unsolved() {
        return new SymbolReference<Object>(null);
    }

    @Deprecated
    public static <S extends ResolvedDeclaration, S2 extends S> SymbolReference<S> unsolved(Class<S2> clazz) {
        return SymbolReference.unsolved();
    }

    public static <I extends ResolvedDeclaration, O extends ResolvedDeclaration> SymbolReference<O> adapt(SymbolReference<I> ref, Class<O> clazz) {
        ResolvedDeclaration symbol;
        Optional<I> declaration = ref.getDeclaration();
        if (declaration.isPresent() && clazz.isInstance(symbol = (ResolvedDeclaration)declaration.get())) {
            return SymbolReference.solved((ResolvedDeclaration)clazz.cast(symbol));
        }
        return SymbolReference.unsolved();
    }

    private SymbolReference(S correspondingDeclaration) {
        this.correspondingDeclaration = correspondingDeclaration;
    }

    public Optional<S> getDeclaration() {
        return Optional.ofNullable(this.correspondingDeclaration);
    }

    public S getCorrespondingDeclaration() {
        Optional<S> declaration = this.getDeclaration();
        if (declaration.isPresent()) {
            return (S)((ResolvedDeclaration)declaration.get());
        }
        throw new UnsolvedSymbolException("Corresponding declaration not available for unsolved symbol.");
    }

    public boolean isSolved() {
        return this.getDeclaration().isPresent();
    }

    public String toString() {
        return "SymbolReference{" + this.correspondingDeclaration + "}";
    }
}

