/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.internal.shaded.javaparser.resolution.declarations;

import java.util.Optional;
import java.util.Set;
import org.moditect.internal.shaded.javaparser.resolution.UnsolvedSymbolException;
import org.moditect.internal.shaded.javaparser.resolution.declarations.ResolvedAnnotationDeclaration;
import org.moditect.internal.shaded.javaparser.resolution.declarations.ResolvedClassDeclaration;
import org.moditect.internal.shaded.javaparser.resolution.declarations.ResolvedDeclaration;
import org.moditect.internal.shaded.javaparser.resolution.declarations.ResolvedEnumDeclaration;
import org.moditect.internal.shaded.javaparser.resolution.declarations.ResolvedInterfaceDeclaration;
import org.moditect.internal.shaded.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.moditect.internal.shaded.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;

public interface ResolvedTypeDeclaration
extends ResolvedDeclaration {
    default public Set<ResolvedReferenceTypeDeclaration> internalTypes() {
        throw new UnsupportedOperationException("InternalTypes not available for " + this.getClass().getCanonicalName());
    }

    default public ResolvedReferenceTypeDeclaration getInternalType(String name) {
        Optional<ResolvedReferenceTypeDeclaration> type = this.internalTypes().stream().filter(f -> f.getName().equals(name)).findFirst();
        return type.orElseThrow(() -> new UnsolvedSymbolException("Internal type not found: " + name));
    }

    default public boolean hasInternalType(String name) {
        return this.internalTypes().stream().anyMatch(f -> f.getName().equals(name));
    }

    public Optional<ResolvedReferenceTypeDeclaration> containerType();

    default public boolean isClass() {
        return false;
    }

    default public boolean isInterface() {
        return false;
    }

    default public boolean isEnum() {
        return false;
    }

    default public boolean isAnnotation() {
        return false;
    }

    default public boolean isReferenceType() {
        return false;
    }

    default public boolean isTypeParameter() {
        return false;
    }

    @Override
    default public boolean isType() {
        return true;
    }

    default public boolean isAnonymousClass() {
        return false;
    }

    @Override
    default public ResolvedTypeDeclaration asType() {
        return this;
    }

    default public ResolvedClassDeclaration asClass() {
        throw new UnsupportedOperationException(String.format("%s is not a class", this));
    }

    default public ResolvedInterfaceDeclaration asInterface() {
        throw new UnsupportedOperationException(String.format("%s is not an interface", this));
    }

    default public ResolvedEnumDeclaration asEnum() {
        throw new UnsupportedOperationException(String.format("%s is not an enum", this));
    }

    default public ResolvedAnnotationDeclaration asAnnotation() {
        throw new UnsupportedOperationException(String.format("%s is not an annotation", this));
    }

    default public ResolvedTypeParameterDeclaration asTypeParameter() {
        throw new UnsupportedOperationException(String.format("%s is not a type parameter", this));
    }

    default public ResolvedReferenceTypeDeclaration asReferenceType() {
        throw new UnsupportedOperationException(String.format("%s is not a reference type", this));
    }

    public String getPackageName();

    public String getClassName();

    public String getQualifiedName();

    default public String getId() {
        String qname = this.getQualifiedName();
        if (qname == null) {
            return String.format("<localClass>:%s", this.getName());
        }
        return qname;
    }
}

