/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.internal.shaded.javaparser.printer.configuration.imports;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.moditect.internal.shaded.javaparser.ast.ImportDeclaration;
import org.moditect.internal.shaded.javaparser.ast.NodeList;
import org.moditect.internal.shaded.javaparser.ast.nodeTypes.NodeWithName;
import org.moditect.internal.shaded.javaparser.printer.configuration.ImportOrderingStrategy;

public class DefaultImportOrderingStrategy
implements ImportOrderingStrategy {
    private boolean sortImportsAlphabetically = false;

    @Override
    public List<NodeList<ImportDeclaration>> sortImports(NodeList<ImportDeclaration> nodes) {
        if (this.sortImportsAlphabetically) {
            Comparator<ImportDeclaration> sortLogic = Comparator.comparingInt(i -> i.isStatic() ? 0 : 1).thenComparing(NodeWithName::getNameAsString);
            nodes.sort(sortLogic);
        }
        return Collections.singletonList(nodes);
    }

    @Override
    public void setSortImportsAlphabetically(boolean sortImportsAlphabetically) {
        this.sortImportsAlphabetically = sortImportsAlphabetically;
    }

    @Override
    public boolean isSortImportsAlphabetically() {
        return this.sortImportsAlphabetically;
    }
}

