/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.internal.shaded.javaparser.ast.expr;

import java.util.Optional;
import java.util.function.Consumer;
import org.moditect.internal.shaded.javaparser.TokenRange;
import org.moditect.internal.shaded.javaparser.ast.AllFieldsConstructor;
import org.moditect.internal.shaded.javaparser.ast.Node;
import org.moditect.internal.shaded.javaparser.ast.expr.Expression;
import org.moditect.internal.shaded.javaparser.ast.expr.StringLiteralExpr;
import org.moditect.internal.shaded.javaparser.ast.observer.ObservableProperty;
import org.moditect.internal.shaded.javaparser.ast.visitor.CloneVisitor;
import org.moditect.internal.shaded.javaparser.ast.visitor.GenericVisitor;
import org.moditect.internal.shaded.javaparser.ast.visitor.VoidVisitor;
import org.moditect.internal.shaded.javaparser.metamodel.EnclosedExprMetaModel;
import org.moditect.internal.shaded.javaparser.metamodel.JavaParserMetaModel;
import org.moditect.internal.shaded.javaparser.utils.Utils;

public class EnclosedExpr
extends Expression {
    private Expression inner;

    public EnclosedExpr() {
        this(null, new StringLiteralExpr());
    }

    @AllFieldsConstructor
    public EnclosedExpr(Expression inner) {
        this(null, inner);
    }

    public EnclosedExpr(TokenRange tokenRange, Expression inner) {
        super(tokenRange);
        this.setInner(inner);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Expression getInner() {
        return this.inner;
    }

    public EnclosedExpr setInner(Expression inner) {
        Utils.assertNotNull(inner);
        if (inner == this.inner) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.INNER, this.inner, inner);
        if (this.inner != null) {
            this.inner.setParentNode(null);
        }
        this.inner = inner;
        this.setAsParentNodeOf(inner);
        return this;
    }

    @Override
    public EnclosedExpr clone() {
        return (EnclosedExpr)this.accept(new CloneVisitor(), null);
    }

    @Override
    public EnclosedExprMetaModel getMetaModel() {
        return JavaParserMetaModel.enclosedExprMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        if (node == this.inner) {
            this.setInner((Expression)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isEnclosedExpr() {
        return true;
    }

    @Override
    public EnclosedExpr asEnclosedExpr() {
        return this;
    }

    @Override
    public void ifEnclosedExpr(Consumer<EnclosedExpr> action) {
        action.accept(this);
    }

    @Override
    public Optional<EnclosedExpr> toEnclosedExpr() {
        return Optional.of(this);
    }

    @Override
    public boolean isPolyExpression() {
        return this.getInner().isPolyExpression();
    }
}

