/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.internal.shaded.javaparser.ast;

import java.util.Optional;
import org.moditect.internal.shaded.javaparser.TokenRange;
import org.moditect.internal.shaded.javaparser.ast.AllFieldsConstructor;
import org.moditect.internal.shaded.javaparser.ast.Node;
import org.moditect.internal.shaded.javaparser.ast.NodeList;
import org.moditect.internal.shaded.javaparser.ast.expr.AnnotationExpr;
import org.moditect.internal.shaded.javaparser.ast.expr.Expression;
import org.moditect.internal.shaded.javaparser.ast.expr.IntegerLiteralExpr;
import org.moditect.internal.shaded.javaparser.ast.nodeTypes.NodeWithAnnotations;
import org.moditect.internal.shaded.javaparser.ast.observer.ObservableProperty;
import org.moditect.internal.shaded.javaparser.ast.visitor.CloneVisitor;
import org.moditect.internal.shaded.javaparser.ast.visitor.GenericVisitor;
import org.moditect.internal.shaded.javaparser.ast.visitor.VoidVisitor;
import org.moditect.internal.shaded.javaparser.metamodel.ArrayCreationLevelMetaModel;
import org.moditect.internal.shaded.javaparser.metamodel.JavaParserMetaModel;
import org.moditect.internal.shaded.javaparser.metamodel.OptionalProperty;
import org.moditect.internal.shaded.javaparser.utils.Utils;

public class ArrayCreationLevel
extends Node
implements NodeWithAnnotations<ArrayCreationLevel> {
    @OptionalProperty
    private Expression dimension;
    private NodeList<AnnotationExpr> annotations = new NodeList();

    public ArrayCreationLevel() {
        this(null, null, new NodeList<AnnotationExpr>());
    }

    public ArrayCreationLevel(int dimension) {
        this(null, new IntegerLiteralExpr("" + dimension), new NodeList<AnnotationExpr>());
    }

    public ArrayCreationLevel(Expression dimension) {
        this(null, dimension, new NodeList<AnnotationExpr>());
    }

    @AllFieldsConstructor
    public ArrayCreationLevel(Expression dimension, NodeList<AnnotationExpr> annotations) {
        this(null, dimension, annotations);
    }

    public ArrayCreationLevel(TokenRange tokenRange, Expression dimension, NodeList<AnnotationExpr> annotations) {
        super(tokenRange);
        this.setDimension(dimension);
        this.setAnnotations((NodeList)annotations);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public ArrayCreationLevel setDimension(Expression dimension) {
        if (dimension == this.dimension) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.DIMENSION, this.dimension, dimension);
        if (this.dimension != null) {
            this.dimension.setParentNode(null);
        }
        this.dimension = dimension;
        this.setAsParentNodeOf(dimension);
        return this;
    }

    public Optional<Expression> getDimension() {
        return Optional.ofNullable(this.dimension);
    }

    @Override
    public NodeList<AnnotationExpr> getAnnotations() {
        return this.annotations;
    }

    @Override
    public ArrayCreationLevel setAnnotations(NodeList<AnnotationExpr> annotations) {
        Utils.assertNotNull(annotations);
        if (annotations == this.annotations) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.ANNOTATIONS, this.annotations, annotations);
        if (this.annotations != null) {
            this.annotations.setParentNode(null);
        }
        this.annotations = annotations;
        this.setAsParentNodeOf(annotations);
        return this;
    }

    public ArrayCreationLevel removeDimension() {
        return this.setDimension(null);
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.annotations.size(); ++i) {
            if (this.annotations.get(i) != node) continue;
            this.annotations.remove(i);
            return true;
        }
        if (this.dimension != null && node == this.dimension) {
            this.removeDimension();
            return true;
        }
        return super.remove(node);
    }

    @Override
    public ArrayCreationLevel clone() {
        return (ArrayCreationLevel)this.accept(new CloneVisitor(), null);
    }

    @Override
    public ArrayCreationLevelMetaModel getMetaModel() {
        return JavaParserMetaModel.arrayCreationLevelMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.annotations.size(); ++i) {
            if (this.annotations.get(i) != node) continue;
            this.annotations.set(i, (AnnotationExpr)replacementNode);
            return true;
        }
        if (this.dimension != null && node == this.dimension) {
            this.setDimension((Expression)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }
}

