/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.internal.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.moditect.spi.log.Log;

public final class JavaVersionHelper {
    private static final String VERSION_REGEXP = "^(\\d+)\\.(\\d+)\\.(\\d+).*";
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+).*");
    private static final String JAVA_VERSION_PROPERTY_NAME = "java.version";
    private final Log log;

    JavaVersionHelper() {
        this.log = null;
    }

    public JavaVersionHelper(Log log) {
        this.log = log;
    }

    public boolean resolveWithVersionIfMultiRelease() {
        Version version = this.javaVersion();
        if (version == null) {
            return false;
        }
        if (version.major >= 14) {
            this.debug("Detected JDK 14+");
            return true;
        }
        if (version.major == 11 && version.minor == 0 && version.mini >= 11) {
            this.debug("Detected JDK 11.0.11+");
            return true;
        }
        return false;
    }

    Version javaVersion() {
        String versionString = System.getProperty(JAVA_VERSION_PROPERTY_NAME);
        this.debug("java.version -> " + versionString);
        return this.javaVersion(versionString);
    }

    Version javaVersion(String versionString) {
        Matcher matcher = VERSION_PATTERN.matcher(versionString);
        if (!matcher.matches()) {
            this.warn("The java version " + versionString + " cannot be parsed as " + VERSION_REGEXP);
            return null;
        }
        try {
            Version version = new Version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
            this.debug("parsed.version -> " + version);
            return version;
        }
        catch (IndexOutOfBoundsException | NumberFormatException ex) {
            this.error("The java version " + versionString + " has an invalid format. " + ex.getMessage());
            return null;
        }
    }

    private void debug(String message) {
        if (this.log != null) {
            this.log.debug(message);
        }
    }

    private void warn(String message) {
        if (this.log != null) {
            this.log.warn(message);
        }
    }

    private void error(String message) {
        if (this.log != null) {
            this.log.error(message);
        }
    }

    static class Version {
        private int major;
        private int minor;
        private int mini;

        private Version(int major, int minor, int mini) {
            this.major = major;
            this.minor = minor;
            this.mini = mini;
        }

        int major() {
            return this.major;
        }

        int minor() {
            return this.minor;
        }

        int mini() {
            return this.mini;
        }

        public String toString() {
            return this.major + "." + this.minor + "." + this.mini;
        }
    }
}

