/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.commands;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.moditect.internal.command.ProcessExecutor;
import org.moditect.model.JarInclusionPolicy;
import org.moditect.spi.log.Log;

public class CreateRuntimeImage {
    private static final String DEPENDENCIES_DIRECTORY = "jars";
    private final Set<Path> modulePath;
    private final List<String> modules;
    private final JarInclusionPolicy jarInclusionPolicy;
    private final Set<Path> dependencies;
    private final Path projectJar;
    private final Path outputDirectory;
    private boolean ignoreSigningInformation;
    private final String launcher;
    private final Log log;
    private final String compression;
    private final boolean stripDebug;
    private final boolean noHeaderFiles;
    private final boolean noManPages;
    private final List<String> excludeResourcesPatterns;
    private final boolean bindServices;

    public CreateRuntimeImage(Set<Path> modulePath, List<String> modules, JarInclusionPolicy jarInclusionPolicy, Set<Path> dependencies, Path projectJar, String launcherName, String launcherModule, Path outputDirectory, String compression, boolean stripDebug, boolean ignoreSigningInformation, List<String> excludeResourcesPatterns, Log log, boolean noHeaderFiles, boolean noManPages, boolean bindServices) {
        this.modulePath = modulePath != null ? modulePath : Collections.emptySet();
        this.modules = CreateRuntimeImage.getModules(modules);
        this.jarInclusionPolicy = jarInclusionPolicy;
        this.dependencies = dependencies;
        this.projectJar = projectJar;
        this.outputDirectory = outputDirectory;
        this.ignoreSigningInformation = ignoreSigningInformation;
        this.launcher = launcherName != null && launcherModule != null ? launcherName + "=" + launcherModule : null;
        this.compression = compression;
        this.stripDebug = stripDebug;
        this.excludeResourcesPatterns = excludeResourcesPatterns;
        this.log = log;
        this.noHeaderFiles = noHeaderFiles;
        this.noManPages = noManPages;
        this.bindServices = bindServices;
    }

    private static List<String> getModules(List<String> modules) {
        if (modules == null || modules.isEmpty()) {
            throw new IllegalArgumentException("At least one module must be added using the <modules> configuration property.");
        }
        return Collections.unmodifiableList(modules);
    }

    public void run() throws IOException {
        this.deleteImageFolder();
        this.runJlink();
        this.log.info("Done creating image");
        this.copyJars();
    }

    private void deleteImageFolder() throws IOException {
        if (!Files.exists(this.outputDirectory, new LinkOption[0])) {
            return;
        }
        this.log.info("Deleting image directory " + this.outputDirectory);
        Files.walkFileTree(this.outputDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc != null) {
                    throw exc;
                }
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void copyJars() throws IOException {
        Path jarDirectory = this.outputDirectory.resolve(DEPENDENCIES_DIRECTORY);
        Files.createDirectories(jarDirectory, new FileAttribute[0]);
        if (this.jarInclusionPolicy.includeAppJar()) {
            this.copyAppJar(jarDirectory);
        }
        if (this.jarInclusionPolicy.includeDependencies()) {
            this.copyDependencyJars(jarDirectory);
        }
    }

    private void copyAppJar(Path jarDirectory) throws IOException {
        this.log.info("Copying project JAR");
        Path target = jarDirectory.resolve(this.projectJar.getFileName());
        Files.copy(this.projectJar, target, new CopyOption[0]);
        this.log.debug(String.format("Done copying app JAR %s to %s", this.projectJar, target));
    }

    private void copyDependencyJars(Path jarDirectory) throws IOException {
        this.log.info("Copying project dependencies");
        for (Path dependency : this.dependencies) {
            Path target = jarDirectory.resolve(dependency.getFileName());
            Files.copy(dependency, target, new CopyOption[0]);
            this.log.debug(String.format("Done copying dependency %s to %s", dependency, target));
        }
        this.log.info("Done copying project dependencies");
    }

    private void runJlink() throws AssertionError {
        this.log.info("Running jlink");
        String javaHome = System.getProperty("java.home");
        String jlinkBin = javaHome + File.separator + "bin" + File.separator + "jlink";
        ArrayList<String> command = new ArrayList<String>();
        command.add(jlinkBin);
        command.add("--add-modules");
        command.add(String.join((CharSequence)",", this.modules));
        command.add("--module-path");
        command.add(this.modulePath.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)));
        command.add("--output");
        command.add(this.outputDirectory.toString());
        if (this.launcher != null) {
            command.add("--launcher");
            command.add(this.launcher);
        }
        if (this.compression != null) {
            command.add("--compress");
            command.add(this.compression);
        }
        if (this.stripDebug) {
            command.add("--strip-debug");
        }
        if (this.ignoreSigningInformation) {
            command.add("--ignore-signing-information");
        }
        if (!this.excludeResourcesPatterns.isEmpty()) {
            command.add("--exclude-resources=" + String.join((CharSequence)",", this.excludeResourcesPatterns));
        }
        if (this.noHeaderFiles) {
            command.add("--no-header-files");
        }
        if (this.noManPages) {
            command.add("--no-man-pages");
        }
        if (this.bindServices) {
            command.add("--bind-services");
        }
        this.log.debug("Running jlink: " + String.join((CharSequence)" ", command));
        ProcessExecutor.run("jlink", command, this.log);
    }
}

