/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class FileLocks {
    private static final FileLocks INSTANCE = new FileLocks();
    private final Lock masterLock = new ReentrantLock();
    private final Map<String, LockHolder> locks = new HashMap<String, LockHolder>();

    public static FileLocks get() {
        return INSTANCE;
    }

    private FileLocks() {
    }

    public WrappedLock writeLock(File file) throws IOException {
        return this.lock(file, true, true);
    }

    public WrappedLock readLock(File file) throws IOException {
        return this.lock(file, false, true);
    }

    public WrappedLock tryWriteLock(File file) throws IOException {
        return this.lock(file, true, false);
    }

    public WrappedLock tryReadLock(File file) throws IOException {
        return this.lock(file, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final WrappedLock lock(File file, boolean writeLock, boolean block) throws IOException {
        LockHolder holder = null;
        try {
            this.masterLock.lock();
            holder = this.locks.get(file.getAbsolutePath());
            if (holder == null) {
                holder = new LockHolder(file);
                this.locks.put(file.getAbsolutePath(), holder);
                WrappedLock wrappedLock = holder.lock(writeLock, block);
                return wrappedLock;
            }
            holder.incrementReferenceCount();
        }
        finally {
            this.masterLock.unlock();
        }
        return holder.lock(writeLock, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlock(LockHolder holder, Lock rawLock) {
        try {
            this.masterLock.lock();
            try {
                if (holder.decrementReferenceCount() == 0) {
                    this.locks.remove(holder.file.getAbsolutePath());
                }
            }
            finally {
                rawLock.unlock();
            }
        }
        finally {
            this.masterLock.unlock();
        }
    }

    public int size() {
        try {
            this.masterLock.lock();
            int n = this.locks.size();
            return n;
        }
        finally {
            this.masterLock.unlock();
        }
    }

    protected final class LockHolder {
        protected final File file;
        protected final WrappedLock readLock;
        protected final WrappedLock writeLock;
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private final AtomicInteger referenceCount = new AtomicInteger(1);
        private final Lock fileLockLock = new ReentrantLock();
        private FileLock fileLock;
        private int lockedReaders = 0;

        protected LockHolder(File file) {
            this.file = file;
            this.readLock = new WrappedLock(this, this.lock.readLock());
            this.writeLock = new WrappedLock(this, this.lock.writeLock());
        }

        protected FileChannel lockedFileChannel() {
            try {
                this.fileLockLock.lock();
                FileChannel fileChannel = this.fileLock != null ? this.fileLock.channel() : null;
                return fileChannel;
            }
            finally {
                this.fileLockLock.unlock();
            }
        }

        protected void incrementReferenceCount() {
            this.referenceCount.incrementAndGet();
        }

        protected int decrementReferenceCount() {
            return this.referenceCount.decrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected WrappedLock lock(boolean write, boolean block) throws IOException {
            if (write) {
                this.lock.writeLock().lock();
                assert (this.fileLock == null);
                assert (this.lockedReaders == 0);
                RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
                FileChannel channel = raf.getChannel();
                if (block) {
                    this.fileLock = channel.lock(0L, Long.MAX_VALUE, false);
                } else {
                    this.fileLock = channel.tryLock(0L, Long.MAX_VALUE, false);
                    if (this.fileLock == null) {
                        this.lock.writeLock().unlock();
                        return null;
                    }
                }
                return this.writeLock;
            }
            this.lock.readLock().lock();
            try {
                this.fileLockLock.lock();
                if (this.fileLock == null) {
                    assert (this.lockedReaders == 0);
                    RandomAccessFile raf = new RandomAccessFile(this.file, "r");
                    FileChannel channel = raf.getChannel();
                    if (block) {
                        this.fileLock = channel.lock(0L, Long.MAX_VALUE, true);
                    } else {
                        this.fileLock = channel.tryLock(0L, Long.MAX_VALUE, true);
                        if (this.fileLock == null) {
                            this.lock.readLock().unlock();
                            WrappedLock wrappedLock = null;
                            return wrappedLock;
                        }
                    }
                } else assert (this.lockedReaders != 0);
                ++this.lockedReaders;
            }
            finally {
                this.fileLockLock.unlock();
            }
            return this.readLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unlock(Lock lock) {
            block17: {
                boolean readLock = lock == this.lock.readLock();
                try {
                    this.fileLockLock.lock();
                    boolean unlock = true;
                    if (readLock) {
                        --this.lockedReaders;
                        if (this.lockedReaders > 0) {
                            unlock = false;
                        }
                    }
                    if (!unlock || this.fileLock == null || !this.fileLock.channel().isOpen()) break block17;
                    try {
                        if (this.fileLock.channel().isOpen()) {
                            this.fileLock.channel().close();
                        } else {
                            this.fileLock.release();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        this.fileLock = null;
                    }
                }
                finally {
                    try {
                        this.fileLockLock.unlock();
                    }
                    finally {
                        FileLocks.this.unlock(this, lock);
                    }
                }
            }
        }

        public String toString() {
            return "FileLockHolder \"" + this.file + "\" (" + this.referenceCount.get() + " referrers)";
        }
    }

    protected static class WrappedLock
    implements Lock {
        protected final LockHolder holder;
        protected final Lock actualLock;

        protected WrappedLock(LockHolder namedLock, Lock lock) {
            this.holder = namedLock;
            this.actualLock = lock;
        }

        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() {
        }

        @Override
        public Condition newCondition() {
            return this.actualLock.newCondition();
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) {
            return true;
        }

        @Override
        public void unlock() {
            this.holder.unlock(this.actualLock);
        }

        public FileChannel lockedFileChannel() {
            return this.holder.lockedFileChannel();
        }
    }
}

