/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.DateTimeUtil;
import org.modeshape.jcr.api.value.DateTime;

@Immutable
public class ModeShapeDateTime
implements DateTime {
    private static final long serialVersionUID = -730188225988292422L;
    private static final int SECONDS_IN_HOUR = 3600;
    private final ZonedDateTime instance;
    private final long millisInUtc;

    public ModeShapeDateTime() {
        this.instance = ZonedDateTime.now();
        this.millisInUtc = this.utcMillis(this.instance);
    }

    public ModeShapeDateTime(String iso8601) {
        this.instance = DateTimeUtil.jodaParse((String)iso8601);
        this.millisInUtc = this.utcMillis(this.instance);
    }

    public ModeShapeDateTime(String iso8601, String timeZoneId) {
        this.instance = DateTimeUtil.jodaParse((String)iso8601).withZoneSameInstant(ZoneId.of(timeZoneId));
        this.millisInUtc = this.utcMillis(this.instance);
    }

    public ModeShapeDateTime(long milliseconds) {
        this.instance = ZonedDateTime.ofInstant(Instant.ofEpochMilli(milliseconds), DateTimeUtil.UTC);
        this.millisInUtc = this.utcMillis(this.instance);
    }

    public ModeShapeDateTime(long milliseconds, String timeZoneId) {
        this.instance = ZonedDateTime.ofInstant(Instant.ofEpochMilli(milliseconds), ZoneId.of(timeZoneId));
        this.millisInUtc = this.utcMillis(this.instance);
    }

    public ModeShapeDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisecondsOfSecond) {
        int nano = (int)TimeUnit.NANOSECONDS.convert(millisecondsOfSecond, TimeUnit.MILLISECONDS);
        this.instance = ZonedDateTime.of(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, nano, DateTimeUtil.UTC);
        this.millisInUtc = this.instance.toInstant().toEpochMilli();
    }

    public ModeShapeDateTime(Date jdkDate) {
        this.instance = ZonedDateTime.ofInstant(jdkDate.toInstant(), TimeZone.getDefault().toZoneId());
        this.millisInUtc = this.utcMillis(this.instance);
    }

    public ModeShapeDateTime(Calendar jdkCalendar) {
        this.instance = ZonedDateTime.ofInstant(jdkCalendar.toInstant(), jdkCalendar.getTimeZone().toZoneId());
        this.millisInUtc = this.utcMillis(this.instance);
    }

    protected ModeShapeDateTime(ZonedDateTime zonedDateTime) {
        this.instance = zonedDateTime;
        this.millisInUtc = this.utcMillis(this.instance);
    }

    public int getMillisOfSecond() {
        return this.instance.get(ChronoField.MILLI_OF_SECOND);
    }

    public long getMilliseconds() {
        return this.instance.toInstant().toEpochMilli();
    }

    public long getMillisecondsInUtc() {
        return this.millisInUtc;
    }

    public String getString() {
        return DateTimeUtil.jodaFormat((ZonedDateTime)this.instance);
    }

    public int getTimeZoneOffsetHours() {
        return this.instance.getOffset().getTotalSeconds() / 3600;
    }

    public String getTimeZoneId() {
        return this.instance.getZone().getId();
    }

    public Calendar toCalendar() {
        return this.toCalendar(null);
    }

    public Calendar toCalendar(Locale locale) {
        Calendar calendar = locale != null ? Calendar.getInstance(locale) : Calendar.getInstance();
        calendar.setTimeInMillis(this.getMilliseconds());
        return calendar;
    }

    public Date toDate() {
        return new Date(this.getMilliseconds());
    }

    public ZonedDateTime toZonedDateTime() {
        return this.instance;
    }

    public LocalDateTime toLocalDateTime() {
        return this.instance.toLocalDateTime();
    }

    public int compareTo(DateTime that) {
        long diff = this.getMillisecondsInUtc() - that.getMillisecondsInUtc();
        return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
    }

    public int hashCode() {
        return (int)this.millisInUtc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DateTime) {
            DateTime that = (DateTime)obj;
            return this.getMillisecondsInUtc() == that.getMillisecondsInUtc();
        }
        if (obj instanceof ZonedDateTime) {
            ZonedDateTime that = (ZonedDateTime)obj;
            return this.getMillisecondsInUtc() == that.withZoneSameInstant(DateTimeUtil.UTC).toInstant().toEpochMilli();
        }
        return false;
    }

    public String toString() {
        return this.getString();
    }

    public ModeShapeDateTime toUtcTimeZone() {
        if (this.instance.getZone().equals(DateTimeUtil.UTC)) {
            return this;
        }
        return new ModeShapeDateTime(this.instance.withZoneSameInstant(DateTimeUtil.UTC));
    }

    public ModeShapeDateTime toTimeZone(String timeZoneId) {
        CheckArg.isNotNull((Object)timeZoneId, (String)"time zone identifier");
        ZoneId zoneId = ZoneId.of(timeZoneId);
        if (this.instance.getZone().equals(zoneId)) {
            return this;
        }
        return new ModeShapeDateTime(this.instance.withZoneSameInstant(zoneId));
    }

    public boolean isBefore(DateTime other) {
        return this.compareTo(other) < 0;
    }

    public boolean isSameAs(DateTime other) {
        return other == this || this.instance.isEqual(other.toZonedDateTime());
    }

    public boolean isAfter(DateTime other) {
        return this.compareTo(other) > 0;
    }

    public DateTime minus(Duration duration) {
        CheckArg.isNotNull((Object)duration, (String)"unit");
        return new ModeShapeDateTime(this.instance.minus(duration));
    }

    public DateTime plus(Duration duration) {
        CheckArg.isNotNull((Object)duration, (String)"unit");
        return new ModeShapeDateTime(this.instance.plus(duration));
    }

    private long utcMillis(ZonedDateTime zonedDateTime) {
        return zonedDateTime.withZoneSameInstant(DateTimeUtil.UTC).toInstant().toEpochMilli();
    }
}

