/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.ValueComparators;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.ValueFormatException;

@Immutable
public abstract class BasicProperty
implements Property {
    private static final long serialVersionUID = 1L;
    private final Name name;

    public BasicProperty(Name name) {
        this.name = name;
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    public Iterator<?> getValues() {
        return this.iterator();
    }

    @Override
    public Object[] getValuesAsArray() {
        if (this.size() == 0) {
            return null;
        }
        Object[] results = new Object[this.size()];
        Iterator iter = this.iterator();
        int index = 0;
        while (iter.hasNext()) {
            Object value = iter.next();
            results[index++] = value;
        }
        return results;
    }

    @Override
    public int compareTo(Property that) {
        if (this == that) {
            return 0;
        }
        int diff = this.getName().compareTo(that.getName());
        if (diff != 0) {
            return diff;
        }
        diff = this.size() - that.size();
        if (diff != 0) {
            return diff;
        }
        Iterator thisIter = this.iterator();
        Iterator thatIter = that.iterator();
        while (thisIter.hasNext()) {
            Object thatValue;
            Object thisValue = thisIter.next();
            diff = ValueComparators.OBJECT_COMPARATOR.compare(thisValue, thatValue = thatIter.next());
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Property) {
            Property that = (Property)obj;
            if (!this.getName().equals(that.getName())) {
                return false;
            }
            if (this.size() != that.size()) {
                return false;
            }
            Iterator thisIter = this.iterator();
            Iterator thatIter = that.iterator();
            while (thisIter.hasNext()) {
                Object thatValue;
                Object thisValue = thisIter.next();
                if (ValueComparators.OBJECT_COMPARATOR.compare(thisValue, thatValue = thatIter.next()) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getString() {
        return this.getString(null, null, null);
    }

    @Override
    public String getString(TextEncoder encoder) {
        return this.getString(null, encoder, null);
    }

    @Override
    public String getString(NamespaceRegistry namespaceRegistry) {
        return this.getString(namespaceRegistry, null, null);
    }

    @Override
    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder) {
        CheckArg.isNotNull((Object)namespaceRegistry, (String)"namespaceRegistry");
        return this.getString(namespaceRegistry, encoder, null);
    }

    @Override
    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder, TextEncoder delimiterEncoder) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().getString(namespaceRegistry, encoder, delimiterEncoder));
        sb.append("=");
        if (this.isEmpty()) {
            sb.append("null");
        } else {
            if (this.isMultiple()) {
                sb.append("[");
            }
            boolean first = true;
            for (Object value : this) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append('\"');
                if (value instanceof Path) {
                    Path path = (Path)value;
                    sb.append(path.getString(namespaceRegistry, encoder, delimiterEncoder));
                } else if (value instanceof Name) {
                    Name name = (Name)value;
                    sb.append(name.getString(namespaceRegistry, encoder, delimiterEncoder));
                } else {
                    sb.append(value);
                }
                sb.append('\"');
            }
            if (this.isMultiple()) {
                sb.append("]");
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(" = ");
        if (this.isSingle()) {
            sb.append(this.getValues().next());
        } else if (this.isEmpty()) {
            sb.append("null");
        } else {
            sb.append(Arrays.asList(this.getValuesAsArray()));
        }
        return sb.toString();
    }

    @Override
    public <T> T[] getValuesAsArray(ValueFactory<T> valueFactory) throws ValueFormatException {
        int size = this.size();
        T[] result = valueFactory.createEmptyArray(size);
        if (size == 0) {
            return result;
        }
        int idx = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            result[idx++] = valueFactory.create(iterator.next());
        }
        return result;
    }

    @Override
    public <T> T[] getValuesAsArray(Property.ValueTypeTransformer<T> valueTypeTransformer, Class<T> type) throws ValueFormatException {
        Object[] result = (Object[])Array.newInstance(type, this.size());
        if (this.size() == 0) {
            return result;
        }
        int idx = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            result[idx++] = valueTypeTransformer.transform(iterator.next());
        }
        return result;
    }
}

