/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.txn;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.Reflection;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.api.txn.TransactionManagerLookup;
import org.modeshape.jcr.txn.LocalTransactionManager;

public class DefaultTransactionManagerLookup
implements TransactionManagerLookup {
    private static final List<String> JNDI_BINDINGS = Arrays.asList("java:jboss/TransactionManager", "java:comp/TransactionManager", "java:comp/UserTransaction", "java:/TransactionManager", "java:appserver/TransactionManager", "java:pm/TransactionManager", "javax.transaction.TransactionManager", "osgi:service/javax.transaction.TransactionManager");
    private static final Logger LOGGER = Logger.getLogger(DefaultTransactionManagerLookup.class);

    public TransactionManager getTransactionManager() {
        return Stream.of(this.getTransactionManagerSuppliers()).map(Supplier::get).filter(Optional::isPresent).map(Optional::get).peek(transactionManager -> LOGGER.debug("Found tx manager '{0}'", new Object[]{transactionManager.getClass().getName()})).findFirst().orElseGet(() -> {
            LOGGER.debug(JcrI18n.warnNoTxManagerFound.text(new Object[0]), new Object[0]);
            return new LocalTransactionManager();
        });
    }

    protected Supplier<Optional<TransactionManager>>[] getTransactionManagerSuppliers() {
        return new Supplier[]{this::lookInJNDI, this::lookForStandaloneJBossJTA, this::lookForAtomikosJTA};
    }

    protected Optional<TransactionManager> lookForAtomikosJTA() {
        LOGGER.debug("Looking for Atomikos JTA...", new Object[0]);
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass("com.atomikos.icatch.jta.UserTransactionManager");
            Object result = clazz.newInstance();
            return result instanceof TransactionManager ? Optional.of((TransactionManager)result) : Optional.empty();
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
        catch (Exception e) {
            LOGGER.debug((Throwable)e, "Error while trying to instantiate an Atomikos JTA instance...", new Object[0]);
            return Optional.empty();
        }
    }

    protected Optional<TransactionManager> lookForStandaloneJBossJTA() {
        LOGGER.debug("Looking for JBoss Standalone JTA...", new Object[0]);
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass("com.arjuna.ats.jta.TransactionManager");
            Method method = Reflection.findMethod(clazz, (String)"transactionManager");
            Object result = Reflection.invokeAccessibly(null, (Method)method, null);
            return result instanceof TransactionManager ? Optional.of((TransactionManager)result) : Optional.empty();
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
        catch (Exception e) {
            LOGGER.debug((Throwable)e, "Error while trying to instantiate a standalone JBoss JTA instance...", new Object[0]);
            return Optional.empty();
        }
    }

    private Optional<TransactionManager> lookInJNDI() {
        return JNDI_BINDINGS.stream().map(this::lookForJNDIName).filter(Objects::nonNull).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionManager lookForJNDIName(String jndiName) {
        InitialContext context = null;
        try {
            context = new InitialContext();
        }
        catch (NamingException e) {
            LOGGER.debug((Throwable)e, "Cannot create initial JNDI context", new Object[0]);
            return null;
        }
        try {
            LOGGER.debug("Looking up transaction manager at: '{0}'", new Object[]{jndiName});
            Object obj = context.lookup(jndiName);
            if (obj instanceof TransactionManager) {
                TransactionManager transactionManager = (TransactionManager)obj;
                return transactionManager;
            }
            LOGGER.debug("Transaction manager not found at: '{0}'", new Object[]{jndiName});
            TransactionManager transactionManager = null;
            return transactionManager;
        }
        catch (NamingException e) {
            LOGGER.debug((Throwable)e, "Failed to lookup '{0}' in JNDI", new Object[]{jndiName});
            TransactionManager transactionManager = null;
            return transactionManager;
        }
        finally {
            try {
                context.close();
            }
            catch (NamingException e) {
                LOGGER.debug((Throwable)e, "Cannot close JNDI context", new Object[0]);
            }
        }
    }
}

