/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.security.acl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.modeshape.common.util.HashCode;
import org.modeshape.jcr.security.acl.PrivilegeImpl;

public class AccessControlEntryImpl
implements AccessControlEntry {
    private Principal principal;
    private ArrayList<Privilege> privileges = new ArrayList();

    public AccessControlEntryImpl(Principal principal, Privilege[] privileges) throws AccessControlException {
        for (Privilege p : privileges) {
            if (p.getName() != null) continue;
            throw new AccessControlException("Invalid privilege");
        }
        assert (principal != null);
        this.principal = principal;
        this.privileges.clear();
        Collections.addAll(this.privileges, privileges);
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Privilege[] getPrivileges() {
        return this.privileges.toArray(new Privilege[this.privileges.size()]);
    }

    protected boolean hasPrivileges(Privilege[] privileges) {
        for (Privilege p : privileges) {
            if (this.contains(this.privileges, p)) continue;
            return false;
        }
        return true;
    }

    private boolean contains(List<Privilege> privileges, Privilege p) {
        for (int i = 0; i < privileges.size(); ++i) {
            if (!((PrivilegeImpl)privileges.get(i)).contains(p)) continue;
            return true;
        }
        return false;
    }

    protected boolean addIfNotPresent(Privilege[] privileges) {
        ArrayList<Privilege> list = new ArrayList<Privilege>();
        Collections.addAll(list, privileges);
        boolean res = this.combineRecursively(list, privileges);
        this.privileges.addAll(list);
        return res;
    }

    protected boolean combineRecursively(List<Privilege> list, Privilege[] privileges) {
        boolean res = false;
        for (Privilege p : privileges) {
            if (p.isAggregate()) {
                res = this.combineRecursively(list, p.getAggregatePrivileges());
                continue;
            }
            if (this.contains(list, p)) continue;
            list.add(p);
            res = true;
        }
        return res;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof AccessControlEntryImpl)) {
            return false;
        }
        AccessControlEntryImpl entry = (AccessControlEntryImpl)other;
        if (!entry.principal.equals(this.principal)) {
            return false;
        }
        if (this.privileges.size() != entry.privileges.size()) {
            return false;
        }
        for (int i = 0; i < this.privileges.size(); ++i) {
            if (this.contains(entry.privileges, this.privileges.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.principal, this.privileges});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ACE: ");
        sb.append(this.principal.getName());
        sb.append("=").append(this.privileges);
        return sb.toString();
    }
}

