/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.engine.process;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.mapdb.Serializer;
import org.modeshape.common.collection.CloseableSupplier;
import org.modeshape.common.collection.EmptyIterator;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.CachedNodeSupplier;
import org.modeshape.jcr.query.BufferManager;
import org.modeshape.jcr.query.NodeSequence;
import org.modeshape.jcr.query.engine.process.BufferedRows;

public class RestartableSequence
extends NodeSequence
implements NodeSequence.Restartable {
    protected final NodeSequence original;
    private final BufferedRows.BufferedRowFactory<? extends BufferedRows.BufferedRow> rowFactory;
    protected final Serializer<BufferedRows.BufferedRow> rowSerializer;
    protected final Queue<NodeSequence.Batch> inMemoryBatches;
    protected final QueueBufferSupplier offHeapBatchesSupplier;
    protected final String workspaceName;
    protected final AtomicLong remainingRowCount = new AtomicLong();
    private final int targetNumRowsInMemory;
    protected final int width;
    private BatchSequence batches;
    protected final AtomicLong batchSize = new AtomicLong();
    protected int actualNumRowsInMemory = 0;
    protected long totalSize = 0L;
    protected boolean loadedAll = false;
    protected boolean usedOffHeap = false;

    public RestartableSequence(String workspaceName, NodeSequence original, BufferManager bufferMgr, CachedNodeSupplier nodeCache, final int numRowsInMemory) {
        this.original = original;
        this.workspaceName = workspaceName;
        this.width = original.width();
        assert (!original.isEmpty());
        assert (original.width() != 0);
        this.rowFactory = BufferedRows.serializer(nodeCache, this.width);
        this.rowSerializer = BufferedRows.serializer(nodeCache, this.width);
        this.targetNumRowsInMemory = numRowsInMemory;
        this.inMemoryBatches = new LinkedList<NodeSequence.Batch>();
        this.offHeapBatchesSupplier = new QueueBufferSupplier(bufferMgr);
        this.batches = new BatchSequence(){
            private final AtomicReference<NodeSequence.Batch> copiedBatch = new AtomicReference();

            @Override
            public NodeSequence.Batch nextBatch() {
                NodeSequence.Batch batch = RestartableSequence.this.original.nextBatch();
                if (batch == null) {
                    RestartableSequence.this.loadedAll = true;
                    return null;
                }
                boolean loadIntoMemory = RestartableSequence.this.inMemoryBatches != null && RestartableSequence.this.actualNumRowsInMemory < numRowsInMemory;
                RestartableSequence.this.totalSize += RestartableSequence.this.loadBatch(batch, loadIntoMemory, this.copiedBatch);
                if (RestartableSequence.this.batchSize.get() == 0L) {
                    RestartableSequence.this.batchSize.set(this.copiedBatch.get().rowCount());
                }
                return this.copiedBatch.get();
            }
        };
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public long getRowCount() {
        if (this.batches == null) {
            return 0L;
        }
        this.loadRemaining();
        return this.totalSize;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public NodeSequence.Batch nextBatch() {
        if (this.batches == null) {
            return null;
        }
        return this.batches.nextBatch();
    }

    @Override
    public void restart() {
        this.loadRemaining();
        this.restartBatches();
    }

    protected void restartBatches() {
        if (this.batches == null) {
            return;
        }
        this.remainingRowCount.set(this.totalSize);
        this.batches = new BatchSequence(){
            private Iterator<NodeSequence.Batch> inMemory;
            private Iterator<BufferedRows.BufferedRow> persisted;
            {
                this.inMemory = RestartableSequence.this.inMemoryBatches.iterator();
            }

            @Override
            public NodeSequence.Batch nextBatch() {
                if (this.inMemory.hasNext()) {
                    NodeSequence.Batch result = this.inMemory.next();
                    if (result instanceof NodeSequence.Restartable) {
                        ((NodeSequence.Restartable)((Object)result)).restart();
                    }
                    return result;
                }
                if (this.persisted == null) {
                    this.persisted = RestartableSequence.this.offHeapBatchesSupplier.iterator();
                }
                if (!this.persisted.hasNext()) {
                    return null;
                }
                return RestartableSequence.this.batchFrom(this.persisted, RestartableSequence.this.batchSize.get());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        RuntimeException error = null;
        try {
            this.original.close();
            return;
        }
        catch (RuntimeException e) {
            error = e;
        }
        finally {
            try {
                this.inMemoryBatches.clear();
                this.totalSize = 0L;
                this.remainingRowCount.set(0L);
                this.offHeapBatchesSupplier.close();
                this.loadedAll = true;
            }
            catch (RuntimeException e) {
                if (error == null) {
                    error = e;
                }
            }
            finally {
                this.batches = null;
                if (error == null) return;
                throw error;
            }
        }
    }

    protected void loadRemaining() {
        if (!this.loadedAll) {
            boolean loadIntoMemory;
            assert ((long)this.targetNumRowsInMemory >= 0L);
            assert (this.batchSize != null);
            NodeSequence.Batch batch = this.original.nextBatch();
            boolean bl = loadIntoMemory = this.inMemoryBatches != null && this.actualNumRowsInMemory < this.targetNumRowsInMemory;
            while (batch != null) {
                long rows = this.loadBatch(batch, loadIntoMemory, null);
                if (this.batchSize.get() == 0L) {
                    this.batchSize.set(rows);
                }
                if (loadIntoMemory) {
                    assert (this.inMemoryBatches != null);
                    if (this.actualNumRowsInMemory >= this.targetNumRowsInMemory) {
                        loadIntoMemory = false;
                    }
                }
                batch = this.original.nextBatch();
            }
            long numInMemory = this.inMemoryBatches != null ? (long)this.actualNumRowsInMemory : 0L;
            this.totalSize = this.offHeapBatchesSupplier.size() + numInMemory;
            this.loadedAll = true;
            this.restartBatches();
        }
    }

    protected long loadBatch(NodeSequence.Batch batch, boolean loadIntoMemory, AtomicReference<NodeSequence.Batch> copyOutput) {
        assert (batch != null);
        if (batch.isEmpty()) {
            if (copyOutput != null) {
                copyOutput.set(batch);
            }
            return 0L;
        }
        if (loadIntoMemory) {
            NodeSequence.Batch copy = NodeSequence.copy(batch);
            this.inMemoryBatches.add(copy);
            if (copyOutput != null) {
                copyOutput.set(copy);
            }
            long numRows = copy.rowCount();
            this.actualNumRowsInMemory = (int)((long)this.actualNumRowsInMemory + numRows);
            return numRows;
        }
        if (copyOutput != null) {
            batch = NodeSequence.copy(batch);
            copyOutput.set(batch);
        }
        long batchSize = 0L;
        Object persistedBatches = this.offHeapBatchesSupplier.get();
        while (batch.hasNext()) {
            batch.nextRow();
            persistedBatches.append(this.createRow(batch));
            ++batchSize;
        }
        if (batch instanceof NodeSequence.Restartable) {
            ((NodeSequence.Restartable)((Object)batch)).restart();
        }
        return batchSize;
    }

    protected BufferedRows.BufferedRow createRow(NodeSequence.Batch currentRow) {
        return this.rowFactory.createRow(currentRow);
    }

    protected NodeSequence.Batch batchFrom(final Iterator<BufferedRows.BufferedRow> rows, long maxBatchSize) {
        if (this.remainingRowCount.get() <= 0L || !rows.hasNext()) {
            return null;
        }
        if (maxBatchSize == 0L) {
            return NodeSequence.emptyBatch(this.workspaceName, this.width);
        }
        final long rowsInBatch = Math.min(maxBatchSize, this.remainingRowCount.get());
        return new NodeSequence.Batch(){
            private BufferedRows.BufferedRow current;

            @Override
            public int width() {
                return RestartableSequence.this.width;
            }

            @Override
            public long rowCount() {
                return rowsInBatch;
            }

            @Override
            public String getWorkspaceName() {
                return RestartableSequence.this.workspaceName;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean hasNext() {
                return RestartableSequence.this.remainingRowCount.get() > 0L && rows.hasNext();
            }

            @Override
            public void nextRow() {
                this.current = (BufferedRows.BufferedRow)rows.next();
                RestartableSequence.this.remainingRowCount.decrementAndGet();
            }

            @Override
            public CachedNode getNode() {
                return this.current.getNode();
            }

            @Override
            public CachedNode getNode(int index) {
                return this.current.getNode(index);
            }

            @Override
            public float getScore() {
                return this.current.getScore();
            }

            @Override
            public float getScore(int index) {
                return this.current.getScore(index);
            }

            public String toString() {
                return "(restartable-batch width=" + RestartableSequence.this.width + " rows=" + this.rowCount() + ")";
            }
        };
    }

    public String toString() {
        return "(restartable total-size=" + this.totalSize + " " + this.original + " )";
    }

    protected class QueueBufferSupplier
    implements CloseableSupplier<BufferManager.QueueBuffer<BufferedRows.BufferedRow>>,
    Iterable<BufferedRows.BufferedRow> {
        private BufferManager.QueueBuffer<BufferedRows.BufferedRow> buffer;
        private final BufferManager bufferMgr;

        protected QueueBufferSupplier(BufferManager bufferMgr) {
            this.bufferMgr = bufferMgr;
        }

        @Override
        public Iterator<BufferedRows.BufferedRow> iterator() {
            return this.buffer != null ? this.buffer.iterator() : new EmptyIterator();
        }

        protected long size() {
            return this.buffer != null ? this.buffer.size() : 0L;
        }

        public BufferManager.QueueBuffer<BufferedRows.BufferedRow> get() {
            if (this.buffer == null) {
                this.buffer = this.bufferMgr.createQueueBuffer(RestartableSequence.this.rowSerializer).useHeap(false).make();
            }
            return this.buffer;
        }

        public void close() {
            if (this.buffer != null) {
                try {
                    this.buffer.close();
                }
                finally {
                    this.buffer = null;
                }
            }
        }
    }

    protected static interface BatchSequence {
        public NodeSequence.Batch nextBatch();
    }
}

