/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.engine.process;

import java.util.ArrayList;
import java.util.Map;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.query.NodeSequence;
import org.modeshape.jcr.query.RowExtractors;
import org.modeshape.jcr.query.model.TypeSystem;

public class DependentQuery
extends NodeSequence {
    protected static final Logger logger = Logger.getLogger(DependentQuery.class);
    private final NodeSequence independentQuery;
    private final RowExtractors.ExtractFromRow independentQueryValueExtractor;
    private final TypeSystem.TypeFactory<?> expectedType;
    private final NodeSequence dependentQuery;
    private final String variableName;
    private final Map<String, Object> variables;
    private boolean ranIndependentQuery;

    public DependentQuery(NodeSequence independentQuery, RowExtractors.ExtractFromRow independentQueryValueExtractor, TypeSystem.TypeFactory<?> expectedType, NodeSequence dependentQuery, String variableName, Map<String, Object> variables) {
        this.independentQuery = independentQuery;
        this.independentQueryValueExtractor = independentQueryValueExtractor;
        this.expectedType = expectedType;
        this.dependentQuery = dependentQuery;
        this.variableName = variableName;
        this.variables = variables;
    }

    @Override
    public long getRowCount() {
        this.initialize();
        return this.dependentQuery.getRowCount();
    }

    @Override
    public int width() {
        this.initialize();
        return this.dependentQuery.width();
    }

    @Override
    public boolean isEmpty() {
        this.initialize();
        return this.dependentQuery.isEmpty();
    }

    @Override
    public NodeSequence.Batch nextBatch() {
        this.initialize();
        return this.dependentQuery.nextBatch();
    }

    protected void initialize() {
        ArrayList<Object> singleColumnResults;
        if (this.ranIndependentQuery) {
            return;
        }
        long size = this.independentQuery.getRowCount();
        NodeSequence.Batch batch = this.independentQuery.nextBatch();
        ArrayList<Object> arrayList = singleColumnResults = size < 0L ? new ArrayList<Object>() : new ArrayList((int)size);
        while (batch != null) {
            if (!batch.isEmpty()) {
                block1: while (batch.hasNext()) {
                    batch.nextRow();
                    Object value = this.independentQueryValueExtractor.getValueInRow(batch);
                    if (value instanceof Object[]) {
                        Object[] values;
                        for (Object oneValue : values = (Object[])value) {
                            if (oneValue == null) continue;
                            oneValue = this.expectedType.create(oneValue);
                            singleColumnResults.add(oneValue);
                            continue block1;
                        }
                        continue;
                    }
                    value = this.expectedType.create(value);
                    singleColumnResults.add(value);
                }
            }
            batch = this.independentQuery.nextBatch();
        }
        if (logger.isTraceEnabled()) {
            LOGGER.trace("Saving variable '{0}' with values: {1}", new Object[]{this.variableName, singleColumnResults});
        }
        this.variables.put(this.variableName, singleColumnResults);
        this.ranIndependentQuery = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        RuntimeException error = null;
        try {
            this.independentQuery.close();
            return;
        }
        catch (RuntimeException e) {
            error = e;
        }
        finally {
            try {
                this.dependentQuery.close();
            }
            catch (RuntimeException e2) {
                if (error == null) {
                    error = e2;
                }
            }
            finally {
                if (error == null) return;
                throw error;
            }
        }
    }
}

