/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.engine.process;

import java.util.Iterator;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.jcr.cache.CachedNodeSupplier;
import org.modeshape.jcr.query.BufferManager;
import org.modeshape.jcr.query.NodeSequence;
import org.modeshape.jcr.query.RowExtractors;
import org.modeshape.jcr.query.engine.process.BufferedRows;
import org.modeshape.jcr.query.engine.process.BufferingSequence;
import org.modeshape.jcr.query.model.TypeSystem;

@NotThreadSafe
public abstract class AbstractNodeKeysSequence
extends BufferingSequence {
    protected final NodeSequence leftSequence;
    protected final int totalWidth;
    private boolean initialized = false;

    protected AbstractNodeKeysSequence(String workspaceName, NodeSequence leftSequence, NodeSequence rightSequence, TypeSystem types, BufferManager bufferMgr, CachedNodeSupplier nodeCache, boolean pack, boolean useHeap) {
        super(workspaceName, rightSequence, RowExtractors.extractUniqueKey(leftSequence.width(), types), bufferMgr, nodeCache, pack, useHeap, true);
        int leftWidth = leftSequence.width();
        int rightWidth = rightSequence.width();
        if (leftWidth > 0 && rightWidth > 0 && leftWidth != rightWidth) {
            throw new IllegalArgumentException("The sequences must have the same width: " + leftSequence + " and " + rightSequence);
        }
        this.totalWidth = leftWidth;
        this.leftSequence = leftSequence;
    }

    @Override
    public NodeSequence.Batch nextBatch() {
        NodeSequence.Batch nextLeftBatch;
        if (!this.initialized) {
            this.loadAll(this.delegate, this.extractor, null);
            this.initialized = true;
        }
        if ((nextLeftBatch = this.leftSequence.nextBatch()) == null) {
            return null;
        }
        return this.batchWrapper(nextLeftBatch);
    }

    @Override
    public int width() {
        return this.totalWidth;
    }

    protected Object keyInLeftRow(NodeSequence.Batch leftBatch) {
        return this.extractor.getValueInRow(leftBatch);
    }

    protected Iterator<BufferedRows.BufferedRow> matchingRightRows(Object keyInLeft) {
        return this.buffer.getAll(keyInLeft);
    }

    protected abstract NodeSequence.Batch batchWrapper(NodeSequence.Batch var1);
}

