/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.PropertyType;
import javax.jcr.query.RowIterator;
import org.modeshape.jcr.query.JcrQueryContext;
import org.modeshape.jcr.query.JcrQueryResult;
import org.modeshape.jcr.query.QueryResults;

public class XPathQueryResult
extends JcrQueryResult {
    public static final String JCR_SCORE_COLUMN_NAME = "jcr:score";
    public static final String JCR_PATH_COLUMN_NAME = "jcr:path";
    public static final String JCR_SCORE_COLUMN_TYPE = PropertyType.nameFromValue((int)4).toUpperCase();
    public static final String JCR_PATH_COLUMN_TYPE = PropertyType.nameFromValue((int)1).toUpperCase();
    private final List<String> columnNames;
    private final List<String> columnTypes;

    public XPathQueryResult(JcrQueryContext context, String query, QueryResults results, boolean restartable, int numRowsInMemory) {
        super(context, query, results, restartable, numRowsInMemory);
        QueryResults.Columns resultColumns = results.getColumns();
        LinkedList<String> columnNames = new LinkedList<String>(resultColumns.getColumnNames());
        LinkedList<String> columnTypes = new LinkedList<String>(resultColumns.getColumnTypes());
        if (resultColumns.hasFullTextSearchScores() && !columnNames.contains(JCR_SCORE_COLUMN_NAME)) {
            columnNames.add(0, JCR_SCORE_COLUMN_NAME);
            columnTypes.add(0, JCR_SCORE_COLUMN_TYPE);
        }
        if (!resultColumns.getColumnNames().contains(JCR_PATH_COLUMN_NAME)) {
            columnNames.add(0, JCR_PATH_COLUMN_NAME);
            columnTypes.add(0, JCR_PATH_COLUMN_TYPE);
        }
        this.columnNames = Collections.unmodifiableList(columnNames);
        this.columnTypes = Collections.unmodifiableList(columnTypes);
    }

    @Override
    protected List<String> getColumnNameList() {
        return this.columnNames;
    }

    @Override
    protected List<String> getColumnTypeList() {
        return this.columnTypes;
    }

    @Override
    public String[] getSelectorNames() {
        return new String[]{"nt:base"};
    }

    @Override
    public RowIterator getRows() {
        return new JcrQueryResult.SingleSelectorQueryResultRowIterator(this.context, this.queryStatement, this.sequence(), this.results.getColumns());
    }
}

