/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.federation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.spi.federation.DocumentWriter;
import org.modeshape.jcr.spi.federation.PageKey;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.basic.BasicMultiValueProperty;
import org.modeshape.jcr.value.basic.BasicSingleValueProperty;
import org.modeshape.schematic.DocumentFactory;
import org.modeshape.schematic.document.Array;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.EditableArray;
import org.modeshape.schematic.document.EditableDocument;

public class FederatedDocumentWriter
implements DocumentWriter {
    private final EditableDocument federatedDocument;
    private final DocumentTranslator translator;

    public FederatedDocumentWriter(DocumentTranslator translator, Document document) {
        this.federatedDocument = document != null ? DocumentFactory.newDocument((Document)document) : DocumentFactory.newDocument();
        this.translator = translator;
    }

    public FederatedDocumentWriter(DocumentTranslator translator) {
        this(translator, null);
    }

    @Override
    public FederatedDocumentWriter setId(String id) {
        assert (id != null);
        this.translator.setKey(this.federatedDocument, id);
        return this;
    }

    protected final Name nameFrom(String name) {
        return (Name)this.translator.getNameFactory().create(name);
    }

    @Override
    public DocumentWriter setPrimaryType(Name name) {
        return this.addProperty(JcrLexicon.PRIMARY_TYPE, (Object)name);
    }

    @Override
    public DocumentWriter setPrimaryType(String name) {
        return this.setPrimaryType(this.nameFrom(name));
    }

    @Override
    public DocumentWriter addMixinType(Name name) {
        return this.addPropertyValue(JcrLexicon.MIXIN_TYPES, (Object)name);
    }

    @Override
    public DocumentWriter addMixinType(String name) {
        return this.addMixinType(this.nameFrom(name));
    }

    @Override
    public DocumentWriter addPropertyValue(Name name, Object value) {
        boolean knownToBeMultiple = false;
        this.translator.addPropertyValues(this.federatedDocument, name, knownToBeMultiple, Collections.singleton(value), null, null);
        return this;
    }

    @Override
    public DocumentWriter addPropertyValue(String name, Object value) {
        return this.addPropertyValue(this.nameFrom(name), value);
    }

    @Override
    public DocumentWriter addProperty(String name, Object value) {
        Name nameObj = this.nameFrom(name);
        return this.addProperty(nameObj, value);
    }

    @Override
    public DocumentWriter addProperty(String name, Object[] values) {
        if (values == null) {
            return this;
        }
        Name nameObj = this.nameFrom(name);
        return this.addProperty(nameObj, values);
    }

    @Override
    public DocumentWriter addProperty(String name, Object firstValue, Object ... additionalValues) {
        Name nameObj = this.nameFrom(name);
        return this.addProperty(nameObj, firstValue, additionalValues);
    }

    @Override
    public DocumentWriter addProperty(Name name, Object value) {
        if (value == null) {
            return this;
        }
        this.translator.setProperty(this.federatedDocument, new BasicSingleValueProperty(name, value), null, null);
        return this;
    }

    @Override
    public DocumentWriter addProperty(Name name, Object[] values) {
        if (values == null) {
            return this;
        }
        int len = values.length;
        if (len == 0) {
            return this;
        }
        if (len == 1) {
            this.translator.setProperty(this.federatedDocument, new BasicSingleValueProperty(name, values[0]), null, null);
        } else {
            this.translator.setProperty(this.federatedDocument, new BasicMultiValueProperty(name, values), null, null);
        }
        return this;
    }

    @Override
    public DocumentWriter addProperty(Name name, Object firstValue, Object ... additionalValues) {
        if (additionalValues.length == 0) {
            this.translator.setProperty(this.federatedDocument, new BasicSingleValueProperty(name, firstValue), null, null);
        } else {
            ArrayList<Object> values = new ArrayList<Object>(1 + additionalValues.length);
            values.add(firstValue);
            for (Object value : additionalValues) {
                values.add(value);
            }
            this.translator.setProperty(this.federatedDocument, new BasicMultiValueProperty(name, values), null, null);
        }
        return this;
    }

    @Override
    public DocumentWriter addProperties(Map<Name, Property> properties) {
        if (properties != null && !properties.isEmpty()) {
            for (Map.Entry<Name, Property> entry : properties.entrySet()) {
                this.translator.setProperty(this.federatedDocument, entry.getValue(), null, null);
            }
        }
        return this;
    }

    @Override
    public DocumentWriter addChild(String id, Name name) {
        String nameStr = this.translator.getStringFactory().create(name);
        return this.addChild(id, nameStr);
    }

    @Override
    public DocumentWriter addChild(String id, String name) {
        EditableArray children = this.federatedDocument.getArray("children");
        if (children == null) {
            children = DocumentFactory.newArray();
            this.federatedDocument.setArray("children", (Array)children);
        }
        children.addDocument((Document)DocumentFactory.newDocument((String)"key", (Object)id, (String)"name", (Object)name));
        return this;
    }

    @Override
    public DocumentWriter removeChild(String id) {
        EditableArray children = this.federatedDocument.getArray("children");
        if (children != null) {
            for (int i = 0; i != children.size(); ++i) {
                Document child;
                Object val = children.get(i);
                if (!(val instanceof Document) || !(child = (Document)val).getString("key").equals(id)) continue;
                children.remove(i);
                return this;
            }
        }
        return this;
    }

    @Override
    public DocumentWriter setProperties(Map<Name, Property> properties) {
        this.federatedDocument.setDocument("properties");
        return this.addProperties(properties);
    }

    @Override
    public DocumentWriter setChildren(List<? extends Document> children) {
        EditableArray childrenArray = DocumentFactory.newArray();
        this.federatedDocument.setArray("children", (Array)childrenArray);
        for (Document document : children) {
            childrenArray.add((Object)document);
        }
        return this;
    }

    @Override
    public DocumentWriter setChildren(LinkedHashMap<String, Name> children) {
        EditableArray childrenArray = DocumentFactory.newArray();
        this.federatedDocument.setArray("children", (Array)childrenArray);
        for (String childId : children.keySet()) {
            this.addChild(childId, children.get(childId));
        }
        return this;
    }

    @Override
    public DocumentWriter setParents(String ... parentIds) {
        if (parentIds.length == 1) {
            this.federatedDocument.setString("parent", parentIds[0]);
        }
        if (parentIds.length > 1) {
            EditableArray parents = DocumentFactory.newArray();
            for (String parentId : parentIds) {
                parents.add((Object)parentId);
            }
            this.federatedDocument.setArray("parent", (Array)parents);
        }
        return this;
    }

    @Override
    public DocumentWriter setParent(String parentId) {
        return this.setParents(parentId);
    }

    @Override
    public DocumentWriter setCacheable(boolean cacheable) {
        this.federatedDocument.setBoolean("$cacheable", cacheable);
        return this;
    }

    @Override
    public DocumentWriter setNotQueryable() {
        this.translator.setQueryable(this.federatedDocument, false);
        return this;
    }

    @Override
    public DocumentWriter setParents(List<String> parentIds) {
        return this.setParents(parentIds.toArray(new String[parentIds.size()]));
    }

    @Override
    public EditableDocument document() {
        return this.federatedDocument;
    }

    @Override
    public DocumentWriter addPage(String parentId, int nextPageOffset, long blockSize, long totalChildCount) {
        return this.addPage(parentId, String.valueOf(nextPageOffset), blockSize, totalChildCount);
    }

    @Override
    public DocumentWriter addPage(String parentId, String nextPageOffset, long blockSize, long totalChildCount) {
        EditableDocument childrenInfo = this.document().getOrCreateDocument("childrenInfo");
        childrenInfo.setNumber("count", totalChildCount);
        childrenInfo.setNumber("blockSize", blockSize);
        PageKey pageKey = new PageKey(parentId, nextPageOffset, blockSize);
        childrenInfo.setString("nextBlock", pageKey.toString());
        return this;
    }

    protected DocumentTranslator translator() {
        return this.translator;
    }
}

