/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.ImmediateFuture;
import org.modeshape.common.util.NamedThreadFactory;
import org.modeshape.jcr.ConfigurationException;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.NoSuchRepositoryException;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.api.Repositories;
import org.modeshape.schematic.document.Changes;

@ThreadSafe
public class ModeShapeEngine
implements Repositories {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final Logger LOGGER = Logger.getLogger(ModeShapeEngine.class);
    private final Map<String, JcrRepository> repositories = new HashMap<String, JcrRepository>();
    private ExecutorService repositoryStarterService;
    private volatile State state = State.NOT_RUNNING;

    protected final boolean checkRunning() {
        if (this.state == State.RUNNING) {
            return true;
        }
        throw new IllegalStateException(JcrI18n.engineIsNotRunning.text(new Object[0]));
    }

    public State getState() {
        return this.state;
    }

    public void start() {
        if (this.state == State.RUNNING) {
            return;
        }
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            this.state = State.STARTING;
            NamedThreadFactory threadFactory = new NamedThreadFactory("modeshape-start-repo");
            this.repositoryStarterService = Executors.newCachedThreadPool((ThreadFactory)threadFactory);
            this.state = State.RUNNING;
        }
        catch (RuntimeException e) {
            this.state = State.NOT_RUNNING;
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public Future<Boolean> shutdown() {
        return this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Boolean> shutdown(boolean forceShutdownOfAllRepositories) {
        if (!forceShutdownOfAllRepositories) {
            Lock lock = this.lock.readLock();
            try {
                lock.lock();
                for (JcrRepository repository : this.repositories.values()) {
                    switch (repository.getState()) {
                        case NOT_RUNNING: 
                        case STOPPING: {
                            break;
                        }
                        case RESTORING: 
                        case RUNNING: 
                        case STARTING: {
                            ImmediateFuture immediateFuture = ImmediateFuture.create((Object)Boolean.FALSE);
                            return immediateFuture;
                        }
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<Boolean> future = executor.submit(this::doShutdown);
            return future;
        }
        finally {
            executor.shutdown();
        }
    }

    protected boolean doShutdown() {
        if (this.state == State.NOT_RUNNING) {
            LOGGER.debug("Engine already shut down.", new Object[0]);
            return true;
        }
        LOGGER.debug("Shutting down engine...", new Object[0]);
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            this.state = State.STOPPING;
            if (!this.repositories.isEmpty()) {
                LinkedList<Future<Boolean>> repoFutures = new LinkedList<Future<Boolean>>();
                LinkedList<String> repoNames = new LinkedList<String>();
                for (JcrRepository repository : this.repositories.values()) {
                    if (repository == null) continue;
                    repoNames.add(repository.getName());
                    repoFutures.add(repository.shutdown());
                }
                while (repoFutures.peek() != null) {
                    String repoName = (String)repoNames.poll();
                    try {
                        ((Future)repoFutures.poll()).get();
                        this.repositories.remove(repoName);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        Logger.getLogger(this.getClass()).error((Throwable)e, (I18nResource)JcrI18n.failedToShutdownDeployedRepository, new Object[]{repoName});
                    }
                }
            }
            if (this.repositories.isEmpty()) {
                this.repositoryStarterService.shutdown();
                this.repositoryStarterService = null;
                this.state = State.NOT_RUNNING;
            } else {
                this.state = State.RUNNING;
            }
        }
        catch (RuntimeException e) {
            this.state = State.RUNNING;
            throw e;
        }
        finally {
            lock.unlock();
        }
        return this.state != State.RUNNING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JcrRepository getRepository(String repositoryName) throws NoSuchRepositoryException {
        CheckArg.isNotEmpty((String)repositoryName, (String)"repositoryName");
        this.checkRunning();
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            JcrRepository repository = this.repositories.get(repositoryName);
            if (repository == null) {
                throw new NoSuchRepositoryException(JcrI18n.repositoryDoesNotExist.text(new Object[]{repositoryName}));
            }
            JcrRepository jcrRepository = repository;
            return jcrRepository;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getRepositoryNames() {
        this.checkRunning();
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            HashSet<String> names = new HashSet<String>();
            for (JcrRepository repository : this.repositories.values()) {
                names.add(repository.getName());
            }
            HashSet<String> hashSet = names;
            return hashSet;
        }
        finally {
            lock.unlock();
        }
    }

    protected Set<String> getRepositoryKeys() {
        this.checkRunning();
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            HashSet<String> hashSet = new HashSet<String>(this.repositories.keySet());
            return hashSet;
        }
        finally {
            lock.unlock();
        }
    }

    public final State getRepositoryState(String repositoryName) throws NoSuchRepositoryException {
        return this.getRepository(repositoryName).getState();
    }

    public final RepositoryConfiguration getRepositoryConfiguration(String repositoryName) throws NoSuchRepositoryException {
        return this.getRepository(repositoryName).getConfiguration();
    }

    public final Future<JcrRepository> startRepository(String repositoryName) throws NoSuchRepositoryException {
        JcrRepository repository = this.getRepository(repositoryName);
        if (repository.getState() == State.RUNNING) {
            return ImmediateFuture.create((Object)repository);
        }
        return this.repositoryStarterService.submit(() -> {
            try {
                repository.start();
                return repository;
            }
            catch (Exception e) {
                this.undeploy(repositoryName);
                throw e;
            }
        });
    }

    public final Future<Boolean> shutdownRepository(String repositoryName) throws NoSuchRepositoryException {
        return this.getRepository(repositoryName).shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, State> getRepositories() {
        this.checkRunning();
        HashMap<String, State> results = new HashMap<String, State>();
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            for (JcrRepository repository : this.repositories.values()) {
                results.put(repository.getName(), repository.getState());
            }
        }
        finally {
            lock.unlock();
        }
        return Collections.unmodifiableMap(results);
    }

    protected Collection<JcrRepository> repositories() {
        if (this.state == State.RUNNING) {
            Lock lock = this.lock.readLock();
            try {
                lock.lock();
                ArrayList<JcrRepository> arrayList = new ArrayList<JcrRepository>(this.repositories.values());
                return arrayList;
            }
            finally {
                lock.unlock();
            }
        }
        return Collections.emptyList();
    }

    public JcrRepository deploy(RepositoryConfiguration repositoryConfiguration) throws ConfigurationException, RepositoryException {
        return this.deploy(repositoryConfiguration, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JcrRepository deploy(RepositoryConfiguration repositoryConfiguration, String repositoryKey) throws ConfigurationException, RepositoryException {
        CheckArg.isNotNull((Object)repositoryConfiguration, (String)"repositoryConfiguration");
        this.checkRunning();
        String repoName = repositoryKey != null ? repositoryKey : repositoryConfiguration.getName();
        Problems problems = repositoryConfiguration.validate();
        if (problems.hasErrors()) {
            throw new ConfigurationException(problems, JcrI18n.repositoryConfigurationIsNotValid.text(new Object[]{repoName, problems.toString()}));
        }
        JcrRepository repository = null;
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            if (this.repositories.containsKey(repoName)) {
                throw new RepositoryException(JcrI18n.repositoryIsAlreadyDeployed.text(new Object[]{repoName}));
            }
            repository = new JcrRepository(repositoryConfiguration);
            this.repositories.put(repoName, repository);
        }
        finally {
            lock.unlock();
        }
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<JcrRepository> update(String repositoryName, Changes changes) throws ConfigurationException, NoSuchRepositoryException, RepositoryException {
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            JcrRepository repository = this.repositories.get(repositoryName);
            if (repository == null) {
                throw new NoSuchRepositoryException(JcrI18n.repositoryDoesNotExist.text(new Object[]{repositoryName}));
            }
            RepositoryConfiguration config = repository.getConfiguration();
            Problems problems = config.validate(changes);
            repository.setConfigurationProblems(problems);
            if (problems.hasErrors()) {
                throw new ConfigurationException(problems, JcrI18n.repositoryConfigurationIsNotValid.text(new Object[]{repositoryName, problems.toString()}));
            }
            try {
                repository.apply(changes);
            }
            catch (Exception e) {
                throw new ConfigurationException(problems, JcrI18n.repositoryConfigurationIsNotValid.text(new Object[]{repositoryName, e.getMessage()}), e);
            }
            ImmediateFuture immediateFuture = new ImmediateFuture((Object)repository);
            return immediateFuture;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Boolean> undeploy(String repositoryName) throws NoSuchRepositoryException {
        CheckArg.isNotEmpty((String)repositoryName, (String)"repositoryName");
        this.checkRunning();
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            JcrRepository repository = this.repositories.remove(repositoryName);
            if (repository == null) {
                throw new NoSuchRepositoryException(JcrI18n.repositoryDoesNotExist.text(new Object[]{repositoryName}));
            }
            Future<Boolean> future = repository.shutdown();
            return future;
        }
        finally {
            lock.unlock();
        }
    }

    public static enum State {
        NOT_RUNNING,
        STARTING,
        RUNNING,
        RESTORING,
        STOPPING;

    }
}

