/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.oauth.entrypoint;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.minbox.framework.oauth.response.AccessTokenInvalidResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

public class AccessTokenInvalidAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private static final String JSON_RESPONSE_CONTENT_TYPE = "application/json;charset=UTF-8";
    private AccessTokenInvalidResponse tokenInvalidResponse;

    public AccessTokenInvalidAuthenticationEntryPoint(AccessTokenInvalidResponse tokenInvalidResponse) {
        this.tokenInvalidResponse = tokenInvalidResponse;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException e) throws IOException, ServletException {
        response.setStatus(this.tokenInvalidResponse.getHttpStatus().value());
        response.setContentType(JSON_RESPONSE_CONTENT_TYPE);
        String responseContent = this.tokenInvalidResponse.serializeResponse(request, e);
        response.getWriter().write(responseContent);
    }

    private AccessTokenInvalidAuthenticationEntryPoint() {
    }
}

