/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.failover.FailoverProxy;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.packet.read.ReadInitialConnectPacket;
import org.mariadb.jdbc.internal.packet.read.ReadPacketFetcher;
import org.mariadb.jdbc.internal.packet.result.ErrorPacket;
import org.mariadb.jdbc.internal.packet.result.OkPacket;
import org.mariadb.jdbc.internal.packet.send.InterfaceAuthSwitchSendResponsePacket;
import org.mariadb.jdbc.internal.packet.send.SendClosePacket;
import org.mariadb.jdbc.internal.packet.send.SendHandshakeResponsePacket;
import org.mariadb.jdbc.internal.packet.send.SendOldPasswordAuthPacket;
import org.mariadb.jdbc.internal.packet.send.SendSslConnectionRequestPacket;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.protocol.authentication.AuthenticationProviderHolder;
import org.mariadb.jdbc.internal.protocol.tls.MariaDbX509KeyManager;
import org.mariadb.jdbc.internal.protocol.tls.MariaDbX509TrustManager;
import org.mariadb.jdbc.internal.queryresults.ExecutionResult;
import org.mariadb.jdbc.internal.queryresults.SingleExecutionResult;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;
import org.mariadb.jdbc.internal.stream.DecompressInputStream;
import org.mariadb.jdbc.internal.stream.MariaDbBufferedInputStream;
import org.mariadb.jdbc.internal.stream.MariaDbInputStream;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.ServerPrepareStatementCache;
import org.mariadb.jdbc.internal.util.SqlStates;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.buffer.Buffer;
import org.mariadb.jdbc.internal.util.constant.HaMode;
import org.mariadb.jdbc.internal.util.constant.ServerStatus;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public abstract class AbstractConnectProtocol
implements Protocol {
    private static Logger logger = LoggerFactory.getLogger(AbstractConnectProtocol.class);
    private final String username;
    private final String password;
    private boolean hostFailed;
    private String version;
    protected boolean checkCallableResultSet;
    private int majorVersion;
    private int minorVersion;
    private int patchVersion;
    private Map<String, String> serverData;
    private Calendar cal;
    protected final ReentrantLock lock;
    protected final UrlParser urlParser;
    protected final Options options;
    protected Socket socket;
    protected PacketOutputStream writer;
    protected boolean readOnly = false;
    protected ReadPacketFetcher packetFetcher;
    protected HostAddress currentHost;
    protected FailoverProxy proxy;
    protected volatile boolean connected = false;
    protected boolean explicitClosed = false;
    protected String database;
    protected long serverThreadId;
    protected ServerPrepareStatementCache serverPrepareStatementCache;
    protected boolean moreResults = false;
    public boolean moreResultsTypeBinary = false;
    public boolean hasWarnings = false;
    public MariaSelectResultSet activeStreamingResult = null;
    public int dataTypeMappingFlags;
    public short serverStatus;

    public AbstractConnectProtocol(UrlParser urlParser, ReentrantLock lock) {
        this.lock = lock;
        this.urlParser = urlParser;
        this.options = this.urlParser.getOptions();
        this.database = urlParser.getDatabase() == null ? "" : urlParser.getDatabase();
        this.username = urlParser.getUsername() == null ? "" : urlParser.getUsername();
        String string = this.password = urlParser.getPassword() == null ? "" : urlParser.getPassword();
        if (this.options.cachePrepStmts) {
            this.serverPrepareStatementCache = ServerPrepareStatementCache.newInstance(this.options.prepStmtCacheSize, this);
        }
        this.setDataTypeMappingFlags();
    }

    @Override
    public void skip() throws SQLException, QueryException {
        if (this.activeStreamingResult != null) {
            this.activeStreamingResult.close();
        }
        while (this.moreResults) {
            SingleExecutionResult execution = new SingleExecutionResult(null, 0, true, false);
            this.getMoreResults(execution);
        }
    }

    @Override
    public abstract void getMoreResults(ExecutionResult var1) throws QueryException;

    @Override
    public void setMoreResults(boolean moreResults, boolean isBinary) {
        this.moreResults = moreResults;
        this.moreResultsTypeBinary = isBinary;
    }

    @Override
    public void close() {
        if (this.lock != null) {
            this.lock.lock();
        }
        this.connected = false;
        try {
            this.skip();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.options.cachePrepStmts) {
                this.serverPrepareStatementCache.clear();
            }
            AbstractConnectProtocol.close(this.packetFetcher, this.writer, this.socket);
        }
        catch (Exception exception) {
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    protected static void close(ReadPacketFetcher fetcher, PacketOutputStream packetOutputStream, Socket socket) throws QueryException {
        SendClosePacket closePacket = new SendClosePacket();
        try {
            try {
                closePacket.send(packetOutputStream);
                socket.shutdownOutput();
                socket.setSoTimeout(3);
                InputStream is = socket.getInputStream();
                while (is.read() != -1) {
                }
            }
            catch (Throwable is) {
                // empty catch block
            }
            packetOutputStream.close();
            fetcher.close();
        }
        catch (IOException e) {
            throw new QueryException("Could not close connection: " + e.getMessage(), -1, SqlStates.CONNECTION_EXCEPTION, (Throwable)e);
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private SSLSocketFactory getSslSocketFactory() throws QueryException {
        if (!this.options.trustServerCertificate && this.options.serverSslCert == null && this.options.trustStore == null && this.options.keyStore == null) {
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        TrustManager[] trustManager = null;
        KeyManager[] keyManager = null;
        if (this.options.trustServerCertificate || this.options.serverSslCert != null || this.options.trustStore != null) {
            trustManager = new X509TrustManager[]{new MariaDbX509TrustManager(this.options)};
        }
        if (this.options.keyStore != null) {
            keyManager = new KeyManager[]{this.loadClientCerts(this.options.keyStore, this.options.keyStorePassword, this.options.keyPassword)};
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManager, trustManager, null);
            return sslContext.getSocketFactory();
        }
        catch (KeyManagementException keyManagementEx) {
            throw new QueryException("Could not initialize SSL context", -1, SqlStates.CONNECTION_EXCEPTION, (Throwable)keyManagementEx);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmEx) {
            throw new QueryException("SSLContext TLS Algorithm not unknown", -1, SqlStates.CONNECTION_EXCEPTION, (Throwable)noSuchAlgorithmEx);
        }
    }

    private KeyManager loadClientCerts(String keyStoreUrl, String keyStorePassword, String keyPassword) throws QueryException {
        InputStream inStream = null;
        try {
            char[] keyStorePasswordChars = keyStorePassword == null ? null : keyStorePassword.toCharArray();
            inStream = new URL(keyStoreUrl).openStream();
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(inStream, keyStorePasswordChars);
            char[] keyStoreChars = keyPassword == null ? keyStorePasswordChars : keyPassword.toCharArray();
            MariaDbX509KeyManager mariaDbX509KeyManager = new MariaDbX509KeyManager(ks, keyStoreChars);
            return mariaDbX509KeyManager;
        }
        catch (GeneralSecurityException generalSecurityEx) {
            throw new QueryException("Failed to create keyStore instance", -1, SqlStates.CONNECTION_EXCEPTION, (Throwable)generalSecurityEx);
        }
        catch (FileNotFoundException fileNotFoundEx) {
            throw new QueryException("Failed to find keyStore file. Option keyStore=" + keyStoreUrl, -1, SqlStates.CONNECTION_EXCEPTION, (Throwable)fileNotFoundEx);
        }
        catch (IOException ioEx) {
            throw new QueryException("Failed to read keyStore file. Option keyStore=" + keyStoreUrl, -1, SqlStates.CONNECTION_EXCEPTION, (Throwable)ioEx);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void initializeSocketOption() {
        try {
            if (!this.options.tcpNoDelay) {
                this.socket.setTcpNoDelay(this.options.tcpNoDelay);
            } else {
                this.socket.setTcpNoDelay(true);
            }
            if (this.options.tcpKeepAlive) {
                this.socket.setKeepAlive(true);
            }
            if (this.options.tcpRcvBuf != null) {
                this.socket.setReceiveBufferSize(this.options.tcpRcvBuf);
            }
            if (this.options.tcpSndBuf != null) {
                this.socket.setSendBufferSize(this.options.tcpSndBuf);
            }
            if (this.options.tcpAbortiveClose) {
                this.socket.setSoLinger(true, 0);
            }
        }
        catch (Exception e) {
            logger.debug("Failed to set socket option", e);
        }
    }

    @Override
    public void connect() throws QueryException {
        if (!this.isClosed()) {
            this.close();
        }
        try {
            if (this.currentHost != null) {
                this.connect(this.currentHost.host, this.currentHost.port);
            } else {
                this.connect(null, 3306);
            }
            return;
        }
        catch (IOException e) {
            throw new QueryException("Could not connect to " + this.currentHost + "." + e.getMessage(), -1, SqlStates.CONNECTION_EXCEPTION, (Throwable)e);
        }
    }

    private void connect(String host, int port) throws QueryException, IOException {
        this.socket = Utils.createSocket(this.urlParser, host);
        this.initializeSocketOption();
        if (this.options.localSocketAddress != null) {
            InetSocketAddress localAddress = new InetSocketAddress(this.options.localSocketAddress, 0);
            this.socket.bind(localAddress);
        }
        if (!this.socket.isConnected()) {
            InetSocketAddress sockAddr;
            InetSocketAddress inetSocketAddress = sockAddr = this.urlParser.getOptions().pipe == null ? new InetSocketAddress(host, port) : null;
            if (this.options.connectTimeout != null) {
                this.socket.connect(sockAddr, this.options.connectTimeout);
            } else {
                this.socket.connect(sockAddr);
            }
        }
        if (this.options.socketTimeout != null) {
            this.socket.setSoTimeout(this.options.socketTimeout);
        }
        this.handleConnectionPhases();
        if (this.options.useCompression) {
            this.writer.setUseCompression(true);
            this.packetFetcher = new ReadPacketFetcher(new DecompressInputStream(this.socket.getInputStream()), this.options.maxQuerySizeToLog);
        }
        this.connected = true;
        this.writer.forceCleanupBuffer();
        this.loadServerData();
        this.setSessionOptions();
        this.writer.setMaxAllowedPacket(Integer.parseInt(this.serverData.get("max_allowed_packet")));
        this.createDatabaseIfNotExist();
        this.loadCalendar();
        this.activeStreamingResult = null;
        this.moreResults = false;
        this.hasWarnings = false;
        this.hostFailed = false;
    }

    @Override
    public boolean isClosed() {
        return !this.connected;
    }

    private void setSessionOptions() throws QueryException {
        String sessionOption = "autocommit=1";
        if (this.options.jdbcCompliantTruncation) {
            if (this.serverData.get("sql_mode") == null || "".equals(this.serverData.get("sql_mode"))) {
                sessionOption = sessionOption + ",sql_mode='STRICT_TRANS_TABLES'";
            } else if (!this.serverData.get("sql_mode").contains("STRICT_TRANS_TABLES")) {
                sessionOption = sessionOption + ",sql_mode='" + this.serverData.get("sql_mode") + ",STRICT_TRANS_TABLES'";
            }
        }
        if (this.options.sessionVariables != null) {
            sessionOption = sessionOption + "," + this.options.sessionVariables;
        }
        this.executeQuery("set session " + sessionOption);
    }

    private void handleConnectionPhases() throws QueryException {
        MariaDbInputStream reader = null;
        try {
            reader = new MariaDbBufferedInputStream(this.socket.getInputStream(), 16384);
            this.packetFetcher = new ReadPacketFetcher(reader, this.options.maxQuerySizeToLog);
            this.writer = new PacketOutputStream(this.socket.getOutputStream(), this.options.profileSql || this.options.slowQueryThresholdNanos != null, this.options.maxQuerySizeToLog);
            ReadInitialConnectPacket greetingPacket = new ReadInitialConnectPacket(this.packetFetcher);
            this.serverThreadId = greetingPacket.getServerThreadId();
            this.version = greetingPacket.getServerVersion();
            this.checkCallableResultSet = this.version.indexOf("MariaDB") == -1;
            byte exchangeCharset = this.decideLanguage(greetingPacket.getServerLanguage());
            this.parseVersion();
            long clientCapabilities = this.initializeClientCapabilities();
            byte packetSeq = 1;
            if (this.options.useSsl && (greetingPacket.getServerCapabilities() & 0x800L) != 0L) {
                SendSslConnectionRequestPacket amcap = new SendSslConnectionRequestPacket(clientCapabilities |= 0x800L, exchangeCharset);
                amcap.send(this.writer);
                SSLSocketFactory sslSocketFactory = this.getSslSocketFactory();
                SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(this.socket, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), true);
                this.enabledSslProtocolSuites(sslSocket);
                this.enabledSslCipherSuites(sslSocket);
                sslSocket.setUseClientMode(true);
                sslSocket.startHandshake();
                this.socket = sslSocket;
                this.writer = new PacketOutputStream(this.socket.getOutputStream(), this.options.profileSql || this.options.slowQueryThresholdNanos != null, this.options.maxQuerySizeToLog);
                reader = new MariaDbBufferedInputStream(this.socket.getInputStream(), 16384);
                this.packetFetcher = new ReadPacketFetcher(reader, this.options.maxQuerySizeToLog);
                packetSeq = (byte)(packetSeq + 1);
            } else if (this.options.useSsl) {
                throw new QueryException("Trying to connect with ssl, but ssl not enabled in the server");
            }
            this.authentication(exchangeCharset, clientCapabilities, greetingPacket.getSeed(), packetSeq, greetingPacket.getPluginName(), greetingPacket.getServerCapabilities());
        }
        catch (IOException e) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new QueryException("Could not connect to " + this.currentHost.host + ":" + this.currentHost.port + ": " + e.getMessage(), -1, SqlStates.CONNECTION_EXCEPTION, (Throwable)e);
        }
    }

    private void authentication(byte exchangeCharset, long clientCapabilities, byte[] seed, byte packetSeq, String plugin, long serverCapabilities) throws QueryException, IOException {
        SendHandshakeResponsePacket cap = new SendHandshakeResponsePacket(this.username, this.password, this.database, clientCapabilities, exchangeCharset, seed, packetSeq, plugin, this.options.connectionAttributes, this.serverThreadId);
        cap.send(this.writer);
        Buffer buffer = this.packetFetcher.getPacket();
        if ((buffer.getByteAt(0) & 0xFF) == 254) {
            InterfaceAuthSwitchSendResponsePacket interfaceSendPacket;
            if ((serverCapabilities & 0x80000L) != 0L) {
                buffer.readByte();
                plugin = buffer.readString(Charset.forName("ASCII"));
                byte[] authData = buffer.readRawBytes(buffer.remaining());
                interfaceSendPacket = AuthenticationProviderHolder.getAuthenticationProvider().processAuthPlugin(this.packetFetcher, plugin, this.password, authData, this.packetFetcher.getLastPacketSeq() + 1);
            } else {
                interfaceSendPacket = new SendOldPasswordAuthPacket(this.password, Utils.copyWithLength(seed, 8), this.packetFetcher.getLastPacketSeq() + 1);
            }
            interfaceSendPacket.send(this.writer);
            interfaceSendPacket.handleResultPacket(this.packetFetcher);
        } else {
            if (buffer.getByteAt(0) == -1) {
                ErrorPacket errorPacket = new ErrorPacket(buffer);
                throw new QueryException("Could not connect: " + errorPacket.getMessage(), (int)errorPacket.getErrorNumber(), errorPacket.getSqlState());
            }
            this.serverStatus = new OkPacket(buffer).getServerStatus();
        }
    }

    private long initializeClientCapabilities() {
        long capabilities = 8594039682L;
        if (this.options.allowMultiQueries || this.options.rewriteBatchedStatements) {
            capabilities |= 0x10000L;
        }
        if (this.options.useCompression) {
            capabilities |= 0x20L;
        }
        if (this.options.interactiveClient) {
            capabilities |= 0x400L;
        }
        if (this.database != null && !this.options.createDatabaseIfNotExist) {
            capabilities |= 8L;
        }
        return capabilities;
    }

    private void createDatabaseIfNotExist() throws QueryException {
        if (this.checkIfMaster() && this.options.createDatabaseIfNotExist) {
            String quotedDb = MariaDbConnection.quoteIdentifier(this.database);
            this.executeQuery("CREATE DATABASE IF NOT EXISTS " + quotedDb);
            this.executeQuery("USE " + quotedDb);
        }
    }

    private void loadCalendar() throws QueryException {
        block6: {
            String timeZone = null;
            if (this.options.serverTimezone != null) {
                timeZone = this.options.serverTimezone;
            }
            if (timeZone == null && "SYSTEM".equals(timeZone = this.getServerData("time_zone"))) {
                timeZone = this.getServerData("system_time_zone");
            }
            if (timeZone != null && timeZone.length() >= 2 && (timeZone.startsWith("+") || timeZone.startsWith("-")) && Character.isDigit(timeZone.charAt(1))) {
                timeZone = "GMT" + timeZone;
            }
            try {
                TimeZone tz = Utils.getTimeZone(timeZone);
                this.cal = Calendar.getInstance(tz);
            }
            catch (SQLException e) {
                this.cal = null;
                if (this.options.useLegacyDatetimeCode) break block6;
                if (this.options.serverTimezone != null) {
                    throw new QueryException("The server time_zone '" + timeZone + "' defined in the 'serverTimezone' parameter cannot be parsed " + "by java TimeZone implementation. See java.util.TimeZone#getAvailableIDs() for available TimeZone, depending on your " + "JRE implementation.", 0, "01S00");
                }
                throw new QueryException("The server time_zone '" + timeZone + "' cannot be parsed. The server time zone must defined in the " + "jdbc url string with the 'serverTimezone' parameter (or server time zone must be defined explicitly).  See " + "java.util.TimeZone#getAvailableIDs() for available TimeZone, depending on your JRE implementation.", 0, "01S00");
            }
        }
    }

    private void loadServerData() throws QueryException, IOException {
        this.serverData = new TreeMap<String, String>();
        SingleExecutionResult qr = new SingleExecutionResult(null, 0, true, false);
        try {
            this.executeQuery(true, qr, "SHOW VARIABLES WHERE Variable_name in ('max_allowed_packet', 'system_time_zone', 'time_zone', 'sql_mode')", 1003);
            MariaSelectResultSet resultSet = qr.getResultSet();
            while (resultSet.next()) {
                logger.debug("server data " + resultSet.getString(1) + " : " + resultSet.getString(2));
                this.serverData.put(resultSet.getString(1), resultSet.getString(2));
            }
        }
        catch (SQLException sqle) {
            throw new QueryException("could not load system variables", -1, SqlStates.CONNECTION_EXCEPTION, (Throwable)sqle);
        }
    }

    @Override
    public String getServerData(String code) {
        return this.serverData.get(code);
    }

    @Override
    public boolean checkIfMaster() throws QueryException {
        return this.isMasterConnection();
    }

    private boolean isServerLanguageUtf8mb4(byte serverLanguage) {
        Byte[] utf8mb4Languages = new Byte[]{(byte)45, (byte)46, (byte)-32, (byte)-31, (byte)-30, (byte)-29, (byte)-28, (byte)-27, (byte)-26, (byte)-25, (byte)-24, (byte)-23, (byte)-22, (byte)-21, (byte)-20, (byte)-19, (byte)-18, (byte)-17, (byte)-16, (byte)-15, (byte)-14, (byte)-13, (byte)-11, (byte)-10, (byte)-9};
        return Arrays.asList(utf8mb4Languages).contains(serverLanguage);
    }

    private byte decideLanguage(byte serverLanguage) {
        byte result = this.isServerLanguageUtf8mb4(serverLanguage) ? serverLanguage : (byte)33;
        return result;
    }

    @Override
    public void readEofPacket() throws QueryException, IOException {
        Buffer buffer = this.packetFetcher.getReusableBuffer();
        switch (buffer.getByteAt(0)) {
            case -2: {
                buffer.skipByte();
                this.hasWarnings = buffer.readShort() > 0;
                this.serverStatus = buffer.readShort();
                break;
            }
            case -1: {
                ErrorPacket ep = new ErrorPacket(buffer);
                throw new QueryException("Could not connect: " + ep.getMessage(), (int)ep.getErrorNumber(), ep.getSqlState());
            }
            default: {
                throw new QueryException("Unexpected stream type " + buffer.getByteAt(0) + " instead of EOF");
            }
        }
    }

    @Override
    public void skipEofPacket() throws QueryException, IOException {
        Buffer buffer = this.packetFetcher.getReusableBuffer();
        switch (buffer.getByteAt(0)) {
            case -2: {
                break;
            }
            case -1: {
                ErrorPacket ep = new ErrorPacket(buffer);
                throw new QueryException("Could not connect: " + ep.getMessage(), (int)ep.getErrorNumber(), ep.getSqlState());
            }
            default: {
                throw new QueryException("Unexpected stream type " + buffer.getByteAt(0) + " instead of EOF");
            }
        }
    }

    @Override
    public void setHostFailedWithoutProxy() {
        this.hostFailed = true;
        this.close();
    }

    @Override
    public UrlParser getUrlParser() {
        return this.urlParser;
    }

    @Override
    public boolean isMasterConnection() {
        return this.currentHost == null ? true : "master".equals(this.currentHost.type);
    }

    @Override
    public boolean mustBeMasterConnection() {
        return true;
    }

    @Override
    public boolean noBackslashEscapes() {
        return (this.serverStatus & ServerStatus.NO_BACKSLASH_ESCAPES) != 0;
    }

    @Override
    public void connectWithoutProxy() throws QueryException {
        LinkedList<HostAddress> hosts;
        List<HostAddress> addrs;
        Random rand;
        block7: {
            if (!this.isClosed()) {
                this.close();
            }
            rand = new Random();
            addrs = this.urlParser.getHostAddresses();
            hosts = new LinkedList<HostAddress>(addrs);
            if (hosts.isEmpty() && this.options.pipe != null) {
                try {
                    this.connect(null, 0);
                    return;
                }
                catch (IOException e) {
                    if (!hosts.isEmpty()) break block7;
                    throw new QueryException("Could not connect to named pipe '" + this.options.pipe + "' : " + e.getMessage(), -1, SqlStates.CONNECTION_EXCEPTION, (Throwable)e);
                }
            }
        }
        while (!hosts.isEmpty()) {
            this.currentHost = this.urlParser.getHaMode().equals((Object)HaMode.LOADBALANCE) ? (HostAddress)hosts.get(rand.nextInt(hosts.size())) : (HostAddress)hosts.get(0);
            hosts.remove(this.currentHost);
            try {
                this.connect(this.currentHost.host, this.currentHost.port);
                return;
            }
            catch (IOException e) {
                if (!hosts.isEmpty()) continue;
                throw new QueryException("Could not connect to " + HostAddress.toString(addrs) + " : " + e.getMessage(), -1, SqlStates.CONNECTION_EXCEPTION, (Throwable)e);
            }
        }
    }

    @Override
    public boolean shouldReconnectWithoutProxy() {
        return (this.serverStatus & ServerStatus.IN_TRANSACTION) == 0 && this.hostFailed && this.urlParser.getOptions().autoReconnect;
    }

    @Override
    public String getServerVersion() {
        return this.version;
    }

    @Override
    public boolean getReadonly() {
        return this.readOnly;
    }

    @Override
    public void setReadonly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public HostAddress getHostAddress() {
        return this.currentHost;
    }

    @Override
    public void setHostAddress(HostAddress host) {
        this.currentHost = host;
        this.readOnly = "slave".equals(this.currentHost.type);
    }

    @Override
    public String getHost() {
        return this.currentHost == null ? null : this.currentHost.host;
    }

    @Override
    public FailoverProxy getProxy() {
        return this.proxy;
    }

    @Override
    public void setProxy(FailoverProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public int getPort() {
        return this.currentHost == null ? 3306 : this.currentHost.port;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    private void parseVersion() {
        String[] versionArray = this.version.split("[^0-9]");
        if (versionArray.length > 0) {
            this.majorVersion = Integer.parseInt(versionArray[0]);
        }
        if (versionArray.length > 1) {
            this.minorVersion = Integer.parseInt(versionArray[1]);
        }
        if (versionArray.length > 2) {
            this.patchVersion = Integer.parseInt(versionArray[2]);
        }
    }

    @Override
    public int getMajorServerVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorServerVersion() {
        return this.minorVersion;
    }

    protected void enabledSslProtocolSuites(SSLSocket sslSocket) throws QueryException {
        if (this.options.enabledSslProtocolSuites == null) {
            sslSocket.setEnabledProtocols(new String[]{"TLSv1", "TLSv1.1"});
        } else {
            String[] protocols;
            List<String> possibleProtocols = Arrays.asList(sslSocket.getSupportedProtocols());
            for (String protocol : protocols = this.options.enabledSslProtocolSuites.split("[,;\\s]+")) {
                if (possibleProtocols.contains(protocol)) continue;
                throw new QueryException("Unsupported SSL protocol '" + protocol + "'. Supported protocols : " + possibleProtocols.toString().replace("[", "").replace("]", ""));
            }
            sslSocket.setEnabledProtocols(protocols);
        }
    }

    protected void enabledSslCipherSuites(SSLSocket sslSocket) throws QueryException {
        if (this.options.enabledSslCipherSuites != null) {
            String[] ciphers;
            List<String> possibleCiphers = Arrays.asList(sslSocket.getSupportedCipherSuites());
            for (String cipher : ciphers = this.options.enabledSslCipherSuites.split("[,;\\s]+")) {
                if (possibleCiphers.contains(cipher)) continue;
                throw new QueryException("Unsupported SSL cipher '" + cipher + "'. Supported ciphers : " + possibleCiphers.toString().replace("[", "").replace("]", ""));
            }
            sslSocket.setEnabledCipherSuites(ciphers);
        }
    }

    @Override
    public boolean versionGreaterOrEqual(int major, int minor, int patch) {
        if (this.majorVersion > major) {
            return true;
        }
        if (this.majorVersion < major) {
            return false;
        }
        if (this.minorVersion > minor) {
            return true;
        }
        if (this.minorVersion < minor) {
            return false;
        }
        if (this.patchVersion > patch) {
            return true;
        }
        return this.patchVersion >= patch;
    }

    @Override
    public boolean getPinGlobalTxToPhysicalConnection() {
        return this.options.pinGlobalTxToPhysicalConnection;
    }

    @Override
    public boolean hasWarnings() {
        this.lock.lock();
        try {
            boolean bl = this.hasWarnings;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isConnected() {
        this.lock.lock();
        try {
            boolean bl = this.connected;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void setDataTypeMappingFlags() {
        this.dataTypeMappingFlags = 0;
        if (this.options.tinyInt1isBit) {
            this.dataTypeMappingFlags |= 1;
        }
        if (this.options.yearIsDateType) {
            this.dataTypeMappingFlags |= 2;
        }
    }

    @Override
    public long getServerThreadId() {
        return this.serverThreadId;
    }

    @Override
    public int getDataTypeMappingFlags() {
        return this.dataTypeMappingFlags;
    }

    @Override
    public boolean isExplicitClosed() {
        return this.explicitClosed;
    }

    @Override
    public Calendar getCalendar() {
        return this.cal;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public void setHasWarnings(boolean hasWarnings) {
        this.hasWarnings = hasWarnings;
    }

    @Override
    public MariaSelectResultSet getActiveStreamingResult() {
        return this.activeStreamingResult;
    }

    @Override
    public void setActiveStreamingResult(MariaSelectResultSet activeStreamingResult) {
        this.activeStreamingResult = activeStreamingResult;
    }

    @Override
    public ReentrantLock getLock() {
        return this.lock;
    }

    @Override
    public boolean hasMoreResults() {
        return this.moreResults;
    }

    @Override
    public ServerPrepareStatementCache prepareStatementCache() {
        return this.serverPrepareStatementCache;
    }

    @Override
    public abstract void executeQuery(String var1) throws QueryException;

    @Override
    public void releaseWriterBuffer() {
        this.writer.releaseBuffer();
    }

    @Override
    public ByteBuffer getWriter() {
        return this.writer.buffer;
    }

    @Override
    public ReadPacketFetcher getPacketFetcher() {
        return this.packetFetcher;
    }

    @Override
    public void changeSocketTcpNoDelay(boolean setTcpNoDelay) throws SocketException {
        this.socket.setTcpNoDelay(setTcpNoDelay);
    }

    @Override
    public void changeSocketSoTimeout(int setSoTimeout) throws SocketException {
        this.socket.setSoTimeout(setSoTimeout);
    }
}

