/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.util.Comparator;

public class StringNaturalCompare
implements Comparator<String> {
    @Override
    public int compare(String s1, String s2) {
        int result = StringNaturalCompare.strnatcmp0(s1, s2, true);
        return result;
    }

    private static int compareRight(String s1, int ind1, String s2, int ind2) {
        int bias = 0;
        while (ind1 != s1.length() || ind2 != s2.length()) {
            if (ind1 == s1.length()) {
                return -1;
            }
            if (ind2 == s2.length()) {
                return 1;
            }
            char a = s1.charAt(ind1);
            char b = s2.charAt(ind2);
            if (!Character.isDigit(a) && !Character.isDigit(b)) {
                return bias;
            }
            if (!Character.isDigit(a)) {
                return -1;
            }
            if (!Character.isDigit(b)) {
                return 1;
            }
            if (a < b) {
                if (bias == 0) {
                    bias = -1;
                }
            } else if (a > b && bias == 0) {
                bias = 1;
            }
            ++ind1;
            ++ind2;
        }
        return bias;
    }

    public static int compareLeft(String s1, int ind1, String s2, int ind2) {
        while (ind1 != s1.length() || ind2 != s2.length()) {
            if (ind1 == s1.length()) {
                return -1;
            }
            if (ind2 == s2.length()) {
                return 1;
            }
            char a = s1.charAt(ind1);
            char b = s2.charAt(ind2);
            if (!Character.isDigit(a) && !Character.isDigit(b)) {
                return 0;
            }
            if (!Character.isDigit(a)) {
                return -1;
            }
            if (!Character.isDigit(b)) {
                return 1;
            }
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
            ++ind1;
            ++ind2;
        }
        return 0;
    }

    public static int strnatcmp0(String s1, String s2, boolean fold_case) {
        int bi = 0;
        int ai = 0;
        while (true) {
            char cb;
            char ca = ai < s1.length() ? s1.charAt(ai) : (char)'\u0000';
            char c = cb = bi < s2.length() ? s2.charAt(bi) : (char)'\u0000';
            while (Character.isWhitespace(ca)) {
                ca = ++ai < s1.length() ? s1.charAt(ai) : (char)'\u0000';
            }
            while (Character.isWhitespace(cb)) {
                cb = ++bi < s2.length() ? s2.charAt(bi) : (char)'\u0000';
            }
            if (Character.isDigit(ca) && Character.isDigit(cb)) {
                int result;
                boolean fractional;
                boolean bl = fractional = ca == '0' || cb == '0';
                if (fractional ? (result = StringNaturalCompare.compareLeft(s1, ai, s2, bi)) != 0 : (result = StringNaturalCompare.compareRight(s1, ai, s2, bi)) != 0) {
                    return result;
                }
            }
            if (ca == '\u0000' && cb == '\u0000') {
                return 0;
            }
            if (fold_case) {
                ca = Character.toUpperCase(ca);
                cb = Character.toUpperCase(cb);
            }
            if (ca < cb) {
                return -1;
            }
            if (ca > cb) {
                return 1;
            }
            ++ai;
            ++bi;
        }
    }
}

