/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.marc4j.MarcPermissiveStreamReader;
import org.marc4j.MarcStreamWriter;
import org.marc4j.marc.Record;

public class SplitFile {
    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        String input = null;
        InputStream inStream = null;
        int count = 100;
        String outBase = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-help") || args[i].equals("-usage")) {
                SplitFile.usage(0);
                continue;
            }
            if (args[i].equals("-count")) {
                if (i == args.length - 1) {
                    SplitFile.usage(1);
                }
                try {
                    count = Integer.parseInt(args[++i].trim());
                }
                catch (NumberFormatException e) {
                    SplitFile.usage(1);
                }
                continue;
            }
            if (args[i].equals("-out")) {
                if (i == args.length - 1) {
                    SplitFile.usage(1);
                }
                outBase = args[++i].trim();
                continue;
            }
            input = args[i].trim();
            if (i == args.length - 1) continue;
            SplitFile.usage(1);
        }
        if (input == null) {
            inStream = System.in;
        } else {
            int idx;
            if (outBase == null && (idx = input.lastIndexOf(46)) > 0) {
                outBase = input.substring(0, idx);
            }
            try {
                inStream = new FileInputStream(input);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        MarcPermissiveStreamReader reader = null;
        try {
            reader = new MarcPermissiveStreamReader(inStream, true, true);
            int fcount = 0;
            while (reader.hasNext()) {
                String outName = String.format("%s-%02d%s", outBase, ++fcount, ".mrc");
                FileOutputStream outStream = new FileOutputStream(outName);
                MarcStreamWriter writer = new MarcStreamWriter((OutputStream)outStream, true);
                for (int i = 0; i < count && reader.hasNext(); ++i) {
                    Record record = reader.next();
                    writer.write(record);
                }
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.err.println("Total time: " + (System.currentTimeMillis() - start) + " miliseconds");
    }

    private static void usage(int status) {
        System.err.println("Usage: org.marc4j.util.SplitFile [-options] <file.mrc>");
        System.err.println("\t-help: print this message");
        System.err.println("\t-count <num>: max number of records in an output file (default: 100)");
        System.err.println("\t-out: basename for output files (default: ouput)");
        System.err.println("\t-usage: print usage info (same as -help)");
        System.exit(status);
    }
}

