/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.marc.impl;

import org.marc4j.MarcException;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.MarcFactory;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.impl.ControlFieldImpl;
import org.marc4j.marc.impl.DataFieldImpl;
import org.marc4j.marc.impl.LeaderImpl;
import org.marc4j.marc.impl.RecordImpl;
import org.marc4j.marc.impl.SubfieldImpl;

public class MarcFactoryImpl
extends MarcFactory {
    @Override
    public ControlField newControlField() {
        return new ControlFieldImpl();
    }

    @Override
    public ControlField newControlField(String tag) {
        return new ControlFieldImpl(tag);
    }

    @Override
    public ControlField newControlField(String tag, String data) {
        return new ControlFieldImpl(tag, data);
    }

    @Override
    public DataField newDataField() {
        return new DataFieldImpl();
    }

    @Override
    public DataField newDataField(String tag, char ind1, char ind2) {
        return new DataFieldImpl(tag, ind1, ind2);
    }

    @Override
    public DataField newDataField(String tag, char ind1, char ind2, String ... subfieldCodesAndData) {
        DataFieldImpl df = new DataFieldImpl(tag, ind1, ind2);
        if (subfieldCodesAndData.length % 2 == 1) {
            throw new MarcException("Error: must provide even number of parameters for subfields: code, data, code, data, ...");
        }
        for (int i = 0; i < subfieldCodesAndData.length; i += 2) {
            if (subfieldCodesAndData[i].length() != 1) {
                throw new MarcException("Error: subfieldCode must be a single character");
            }
            Subfield sf = this.newSubfield(subfieldCodesAndData[i].charAt(0), subfieldCodesAndData[i + 1]);
            df.addSubfield(sf);
        }
        return df;
    }

    @Override
    public Leader newLeader() {
        return new LeaderImpl();
    }

    @Override
    public Leader newLeader(String ldr) {
        return new LeaderImpl(ldr);
    }

    @Override
    public Record newRecord() {
        return this.newRecord(new LeaderImpl("00000nam a2200000 a 4500"));
    }

    @Override
    public Subfield newSubfield() {
        return new SubfieldImpl();
    }

    @Override
    public Subfield newSubfield(char code) {
        return new SubfieldImpl(code);
    }

    @Override
    public Subfield newSubfield(char code, String data) {
        return new SubfieldImpl(code, data);
    }

    @Override
    public Record newRecord(Leader leader) {
        RecordImpl record = new RecordImpl();
        record.setLeader(leader);
        return record;
    }

    @Override
    public Record newRecord(String leader) {
        return this.newRecord(new LeaderImpl(leader));
    }
}

