/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

import org.marc4j.converter.CharConverter;

public class Iso5426ToUnicode
extends CharConverter {
    @Override
    public String convert(char[] data) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            char c = data[i];
            int len = data.length;
            if (this.isAscii(c)) {
                sb.append(c);
                continue;
            }
            if (this.isCombining(c) && this.hasNext(i, len)) {
                char d = this.getCombiningChar(c * 256 + data[i + 1]);
                if (d != '\u0000') {
                    sb.append(d);
                    ++i;
                    continue;
                }
                sb.append(this.getChar(c));
                continue;
            }
            sb.append(this.getChar(c));
        }
        return sb.toString();
    }

    private boolean hasNext(int pos, int len) {
        return pos < len - 1;
    }

    private boolean isAscii(int i) {
        return i >= 0 && i <= 127;
    }

    private boolean isCombining(int i) {
        return i >= 192 && i <= 223;
    }

    @Override
    public boolean outputsUnicode() {
        return true;
    }

    private char getChar(int i) {
        switch (i) {
            case 161: {
                return '\u00a1';
            }
            case 162: {
                return '\u201e';
            }
            case 163: {
                return '\u00a3';
            }
            case 164: {
                return '$';
            }
            case 165: {
                return '\u00a5';
            }
            case 166: {
                return '\u2020';
            }
            case 167: {
                return '\u00a7';
            }
            case 168: {
                return '\u2032';
            }
            case 169: {
                return '\u2018';
            }
            case 170: {
                return '\u201c';
            }
            case 171: {
                return '\u00ab';
            }
            case 172: {
                return '\u266d';
            }
            case 173: {
                return '\u00a9';
            }
            case 174: {
                return '\u2117';
            }
            case 175: {
                return '\u00ae';
            }
            case 176: {
                return '\u02bb';
            }
            case 177: {
                return '\u02bc';
            }
            case 178: {
                return '\u201a';
            }
            case 182: {
                return '\u2021';
            }
            case 183: {
                return '\u00b7';
            }
            case 184: {
                return '\u2033';
            }
            case 185: {
                return '\u2019';
            }
            case 186: {
                return '\u201d';
            }
            case 187: {
                return '\u00bb';
            }
            case 188: {
                return '\u266f';
            }
            case 189: {
                return '\u02b9';
            }
            case 190: {
                return '\u02ba';
            }
            case 191: {
                return '\u00bf';
            }
            case 225: {
                return '\u00c6';
            }
            case 226: {
                return '\u0110';
            }
            case 230: {
                return '\u0132';
            }
            case 232: {
                return '\u0141';
            }
            case 233: {
                return '\u00d8';
            }
            case 234: {
                return '\u0152';
            }
            case 236: {
                return '\u00de';
            }
            case 241: {
                return '\u00e6';
            }
            case 242: {
                return '\u0111';
            }
            case 243: {
                return '\u00f0';
            }
            case 245: {
                return '\u0131';
            }
            case 246: {
                return '\u0133';
            }
            case 248: {
                return '\u0142';
            }
            case 249: {
                return '\u00f8';
            }
            case 250: {
                return '\u0153';
            }
            case 251: {
                return '\u00df';
            }
            case 252: {
                return '\u00fe';
            }
        }
        return (char)i;
    }

    private char getCombiningChar(int i) {
        switch (i) {
            case 49217: {
                return '\u1ea2';
            }
            case 49221: {
                return '\u1eba';
            }
            case 49225: {
                return '\u1ec8';
            }
            case 49231: {
                return '\u1ece';
            }
            case 49237: {
                return '\u1ee6';
            }
            case 49241: {
                return '\u1ef6';
            }
            case 49249: {
                return '\u1ea3';
            }
            case 49253: {
                return '\u1ebb';
            }
            case 49257: {
                return '\u1ec9';
            }
            case 49263: {
                return '\u1ecf';
            }
            case 49269: {
                return '\u1ee7';
            }
            case 49273: {
                return '\u1ef7';
            }
            case 49473: {
                return '\u00c0';
            }
            case 49477: {
                return '\u00c8';
            }
            case 49481: {
                return '\u00cc';
            }
            case 49487: {
                return '\u00d2';
            }
            case 49493: {
                return '\u00d9';
            }
            case 49495: {
                return '\u1e80';
            }
            case 49497: {
                return '\u1ef2';
            }
            case 49505: {
                return '\u00e0';
            }
            case 49509: {
                return '\u00e8';
            }
            case 49513: {
                return '\u00ec';
            }
            case 49519: {
                return '\u00f2';
            }
            case 49525: {
                return '\u00f9';
            }
            case 49527: {
                return '\u1e81';
            }
            case 49529: {
                return '\u1ef3';
            }
            case 49729: {
                return '\u00c1';
            }
            case 49731: {
                return '\u0106';
            }
            case 49733: {
                return '\u00c9';
            }
            case 49735: {
                return '\u01f4';
            }
            case 49737: {
                return '\u00cd';
            }
            case 49739: {
                return '\u1e30';
            }
            case 49740: {
                return '\u0139';
            }
            case 49741: {
                return '\u1e3e';
            }
            case 49742: {
                return '\u0143';
            }
            case 49743: {
                return '\u00d3';
            }
            case 49744: {
                return '\u1e54';
            }
            case 49746: {
                return '\u0154';
            }
            case 49747: {
                return '\u015a';
            }
            case 49749: {
                return '\u00da';
            }
            case 49751: {
                return '\u1e82';
            }
            case 49753: {
                return '\u00dd';
            }
            case 49754: {
                return '\u0179';
            }
            case 49761: {
                return '\u00e1';
            }
            case 49763: {
                return '\u0107';
            }
            case 49765: {
                return '\u00e9';
            }
            case 49767: {
                return '\u01f5';
            }
            case 49769: {
                return '\u00ed';
            }
            case 49771: {
                return '\u1e31';
            }
            case 49772: {
                return '\u013a';
            }
            case 49773: {
                return '\u1e3f';
            }
            case 49774: {
                return '\u0144';
            }
            case 49775: {
                return '\u00f3';
            }
            case 49776: {
                return '\u1e55';
            }
            case 49778: {
                return '\u0155';
            }
            case 49779: {
                return '\u015b';
            }
            case 49781: {
                return '\u00fa';
            }
            case 49783: {
                return '\u1e83';
            }
            case 49785: {
                return '\u00fd';
            }
            case 49786: {
                return '\u017a';
            }
            case 49889: {
                return '\u01fc';
            }
            case 49905: {
                return '\u01fd';
            }
            case 49985: {
                return '\u00c2';
            }
            case 49987: {
                return '\u0108';
            }
            case 49989: {
                return '\u00ca';
            }
            case 49991: {
                return '\u011c';
            }
            case 49992: {
                return '\u0124';
            }
            case 49993: {
                return '\u00ce';
            }
            case 49994: {
                return '\u0134';
            }
            case 49999: {
                return '\u00d4';
            }
            case 50003: {
                return '\u015c';
            }
            case 50005: {
                return '\u00db';
            }
            case 50007: {
                return '\u0174';
            }
            case 50009: {
                return '\u0176';
            }
            case 50010: {
                return '\u1e90';
            }
            case 50017: {
                return '\u00e2';
            }
            case 50019: {
                return '\u0109';
            }
            case 50021: {
                return '\u00ea';
            }
            case 50023: {
                return '\u011d';
            }
            case 50024: {
                return '\u0125';
            }
            case 50025: {
                return '\u00ee';
            }
            case 50026: {
                return '\u0135';
            }
            case 50031: {
                return '\u00f4';
            }
            case 50035: {
                return '\u015d';
            }
            case 50037: {
                return '\u00fb';
            }
            case 50039: {
                return '\u0175';
            }
            case 50041: {
                return '\u0177';
            }
            case 50042: {
                return '\u1e91';
            }
            case 50241: {
                return '\u00c3';
            }
            case 50245: {
                return '\u1ebc';
            }
            case 50249: {
                return '\u0128';
            }
            case 50254: {
                return '\u00d1';
            }
            case 50255: {
                return '\u00d5';
            }
            case 50261: {
                return '\u0168';
            }
            case 50262: {
                return '\u1e7c';
            }
            case 50265: {
                return '\u1ef8';
            }
            case 50273: {
                return '\u00e3';
            }
            case 50277: {
                return '\u1ebd';
            }
            case 50281: {
                return '\u0129';
            }
            case 50286: {
                return '\u00f1';
            }
            case 50287: {
                return '\u00f5';
            }
            case 50293: {
                return '\u0169';
            }
            case 50294: {
                return '\u1e7d';
            }
            case 50297: {
                return '\u1ef9';
            }
            case 50497: {
                return '\u0100';
            }
            case 50501: {
                return '\u0112';
            }
            case 50503: {
                return '\u1e20';
            }
            case 50505: {
                return '\u012a';
            }
            case 50511: {
                return '\u014c';
            }
            case 50517: {
                return '\u016a';
            }
            case 50529: {
                return '\u0101';
            }
            case 50533: {
                return '\u0113';
            }
            case 50535: {
                return '\u1e21';
            }
            case 50537: {
                return '\u012b';
            }
            case 50543: {
                return '\u014d';
            }
            case 50549: {
                return '\u016b';
            }
            case 50657: {
                return '\u01e2';
            }
            case 50673: {
                return '\u01e3';
            }
            case 50753: {
                return '\u0102';
            }
            case 50757: {
                return '\u0114';
            }
            case 50759: {
                return '\u011e';
            }
            case 50761: {
                return '\u012c';
            }
            case 50767: {
                return '\u014e';
            }
            case 50773: {
                return '\u016c';
            }
            case 50785: {
                return '\u0103';
            }
            case 50789: {
                return '\u0115';
            }
            case 50791: {
                return '\u011f';
            }
            case 50793: {
                return '\u012d';
            }
            case 50799: {
                return '\u014f';
            }
            case 50805: {
                return '\u016d';
            }
            case 51010: {
                return '\u1e02';
            }
            case 51011: {
                return '\u010a';
            }
            case 51012: {
                return '\u1e0a';
            }
            case 51013: {
                return '\u0116';
            }
            case 51014: {
                return '\u1e1e';
            }
            case 51015: {
                return '\u0120';
            }
            case 51016: {
                return '\u1e22';
            }
            case 51017: {
                return '\u0130';
            }
            case 51021: {
                return '\u1e40';
            }
            case 51022: {
                return '\u1e44';
            }
            case 51024: {
                return '\u1e56';
            }
            case 51026: {
                return '\u1e58';
            }
            case 51027: {
                return '\u1e60';
            }
            case 51028: {
                return '\u1e6a';
            }
            case 51031: {
                return '\u1e86';
            }
            case 51032: {
                return '\u1e8a';
            }
            case 51033: {
                return '\u1e8e';
            }
            case 51034: {
                return '\u017b';
            }
            case 51042: {
                return '\u1e03';
            }
            case 51043: {
                return '\u010b';
            }
            case 51044: {
                return '\u1e0b';
            }
            case 51045: {
                return '\u0117';
            }
            case 51046: {
                return '\u1e1f';
            }
            case 51047: {
                return '\u0121';
            }
            case 51048: {
                return '\u1e23';
            }
            case 51053: {
                return '\u1e41';
            }
            case 51054: {
                return '\u1e45';
            }
            case 51056: {
                return '\u1e57';
            }
            case 51058: {
                return '\u1e59';
            }
            case 51059: {
                return '\u1e61';
            }
            case 51060: {
                return '\u1e6b';
            }
            case 51063: {
                return '\u1e87';
            }
            case 51064: {
                return '\u1e8b';
            }
            case 51065: {
                return '\u1e8f';
            }
            case 51066: {
                return '\u017c';
            }
            case 51232: {
                return '\u00a8';
            }
            case 51265: {
                return '\u00c4';
            }
            case 51269: {
                return '\u00cb';
            }
            case 51272: {
                return '\u1e26';
            }
            case 51273: {
                return '\u00cf';
            }
            case 51279: {
                return '\u00d6';
            }
            case 51285: {
                return '\u00dc';
            }
            case 51287: {
                return '\u1e84';
            }
            case 51288: {
                return '\u1e8c';
            }
            case 51289: {
                return '\u0178';
            }
            case 51297: {
                return '\u00e4';
            }
            case 51301: {
                return '\u00eb';
            }
            case 51304: {
                return '\u1e27';
            }
            case 51305: {
                return '\u00ef';
            }
            case 51311: {
                return '\u00f6';
            }
            case 51316: {
                return '\u1e97';
            }
            case 51317: {
                return '\u00fc';
            }
            case 51319: {
                return '\u1e85';
            }
            case 51320: {
                return '\u1e8d';
            }
            case 51321: {
                return '\u00ff';
            }
            case 51488: {
                return '\u00a8';
            }
            case 51521: {
                return '\u00c4';
            }
            case 51525: {
                return '\u00cb';
            }
            case 51528: {
                return '\u1e26';
            }
            case 51529: {
                return '\u00cf';
            }
            case 51535: {
                return '\u00d6';
            }
            case 51541: {
                return '\u00dc';
            }
            case 51543: {
                return '\u1e84';
            }
            case 51544: {
                return '\u1e8c';
            }
            case 51545: {
                return '\u0178';
            }
            case 51553: {
                return '\u00e4';
            }
            case 51557: {
                return '\u00eb';
            }
            case 51560: {
                return '\u1e27';
            }
            case 51561: {
                return '\u00ef';
            }
            case 51567: {
                return '\u00f6';
            }
            case 51572: {
                return '\u1e97';
            }
            case 51573: {
                return '\u00fc';
            }
            case 51575: {
                return '\u1e85';
            }
            case 51576: {
                return '\u1e8d';
            }
            case 51577: {
                return '\u00ff';
            }
            case 51777: {
                return '\u00c5';
            }
            case 51885: {
                return '\u016e';
            }
            case 51809: {
                return '\u00e5';
            }
            case 51829: {
                return '\u016f';
            }
            case 51831: {
                return '\u1e98';
            }
            case 51833: {
                return '\u1e99';
            }
            case 52559: {
                return '\u0150';
            }
            case 52565: {
                return '\u0170';
            }
            case 52591: {
                return '\u0151';
            }
            case 52597: {
                return '\u0171';
            }
            case 52820: {
                return '\u01a0';
            }
            case 52821: {
                return '\u01af';
            }
            case 52852: {
                return '\u01a1';
            }
            case 52853: {
                return '\u01b0';
            }
            case 53057: {
                return '\u01cd';
            }
            case 53059: {
                return '\u010c';
            }
            case 53060: {
                return '\u010e';
            }
            case 53061: {
                return '\u011a';
            }
            case 53063: {
                return '\u01e6';
            }
            case 53065: {
                return '\u01cf';
            }
            case 53067: {
                return '\u01e8';
            }
            case 53068: {
                return '\u013d';
            }
            case 53070: {
                return '\u0147';
            }
            case 53071: {
                return '\u01d1';
            }
            case 53074: {
                return '\u0158';
            }
            case 53075: {
                return '\u0160';
            }
            case 53076: {
                return '\u0164';
            }
            case 53077: {
                return '\u01d3';
            }
            case 53082: {
                return '\u017d';
            }
            case 53089: {
                return '\u01ce';
            }
            case 53091: {
                return '\u010d';
            }
            case 53092: {
                return '\u010f';
            }
            case 53093: {
                return '\u011b';
            }
            case 53095: {
                return '\u01e7';
            }
            case 53097: {
                return '\u01d0';
            }
            case 53098: {
                return '\u01f0';
            }
            case 53099: {
                return '\u01e9';
            }
            case 53100: {
                return '\u013e';
            }
            case 53102: {
                return '\u0148';
            }
            case 53103: {
                return '\u01d2';
            }
            case 53106: {
                return '\u0159';
            }
            case 53107: {
                return '\u0161';
            }
            case 53108: {
                return '\u0165';
            }
            case 53109: {
                return '\u01d4';
            }
            case 53114: {
                return '\u017e';
            }
            case 53280: {
                return '\u00b8';
            }
            case 53315: {
                return '\u00c7';
            }
            case 53316: {
                return '\u1e10';
            }
            case 53319: {
                return '\u0122';
            }
            case 53320: {
                return '\u1e28';
            }
            case 53323: {
                return '\u0136';
            }
            case 53324: {
                return '\u013b';
            }
            case 53326: {
                return '\u0145';
            }
            case 53330: {
                return '\u0156';
            }
            case 53331: {
                return '\u015e';
            }
            case 53332: {
                return '\u0162';
            }
            case 53347: {
                return '\u00e7';
            }
            case 53348: {
                return '\u1e11';
            }
            case 53351: {
                return '\u0123';
            }
            case 53352: {
                return '\u1e29';
            }
            case 53355: {
                return '\u0137';
            }
            case 53356: {
                return '\u013c';
            }
            case 53358: {
                return '\u0146';
            }
            case 53362: {
                return '\u0157';
            }
            case 53363: {
                return '\u015f';
            }
            case 53364: {
                return '\u0163';
            }
            case 54048: {
                return '\u02db';
            }
            case 54081: {
                return '\u0104';
            }
            case 54085: {
                return '\u0118';
            }
            case 54089: {
                return '\u012e';
            }
            case 54095: {
                return '\u01ea';
            }
            case 54101: {
                return '\u0172';
            }
            case 54113: {
                return '\u0105';
            }
            case 54117: {
                return '\u0119';
            }
            case 54121: {
                return '\u012f';
            }
            case 54127: {
                return '\u01eb';
            }
            case 54133: {
                return '\u0173';
            }
            case 54337: {
                return '\u1e00';
            }
            case 54369: {
                return '\u1e01';
            }
            case 63816: {
                return '\u1e2a';
            }
            case 63848: {
                return '\u1e2b';
            }
            case 54849: {
                return '\u1ea0';
            }
            case 54850: {
                return '\u1e04';
            }
            case 54852: {
                return '\u1e0c';
            }
            case 54853: {
                return '\u1eb8';
            }
            case 54856: {
                return '\u1e24';
            }
            case 54857: {
                return '\u1eca';
            }
            case 54859: {
                return '\u1e32';
            }
            case 54860: {
                return '\u1e36';
            }
            case 54861: {
                return '\u1e42';
            }
            case 54862: {
                return '\u1e46';
            }
            case 54863: {
                return '\u1ecc';
            }
            case 54866: {
                return '\u1e5a';
            }
            case 54867: {
                return '\u1e62';
            }
            case 54868: {
                return '\u1e6c';
            }
            case 54869: {
                return '\u1ee4';
            }
            case 54870: {
                return '\u1e7e';
            }
            case 54871: {
                return '\u1e88';
            }
            case 54873: {
                return '\u1ef4';
            }
            case 54874: {
                return '\u1e92';
            }
            case 54881: {
                return '\u1ea1';
            }
            case 54882: {
                return '\u1e05';
            }
            case 54884: {
                return '\u1e0d';
            }
            case 54885: {
                return '\u1eb9';
            }
            case 54888: {
                return '\u1e25';
            }
            case 54889: {
                return '\u1ecb';
            }
            case 54891: {
                return '\u1e33';
            }
            case 54892: {
                return '\u1e37';
            }
            case 54893: {
                return '\u1e43';
            }
            case 54894: {
                return '\u1e47';
            }
            case 54895: {
                return '\u1ecd';
            }
            case 54898: {
                return '\u1e5b';
            }
            case 54899: {
                return '\u1e63';
            }
            case 54900: {
                return '\u1e6d';
            }
            case 54901: {
                return '\u1ee5';
            }
            case 54902: {
                return '\u1e7f';
            }
            case 54903: {
                return '\u1e89';
            }
            case 54905: {
                return '\u1ef5';
            }
            case 54906: {
                return '\u1e93';
            }
            case 55125: {
                return '\u1e72';
            }
            case 55157: {
                return '\u1e73';
            }
            case 55328: {
                return '_';
            }
            case 55584: {
                return '\u2017';
            }
            case 55840: {
                return '\u02cc';
            }
        }
        return '\u0000';
    }
}

