/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

public class FixDoubleWidth {
    public static final String COMBINED_DOUBLE_LIGATURE = "\u0361";
    public static final char LIGATURE_FIRST_HALF = '\ufe20';
    public static final char LIGATURE_SECOND_HALF = '\ufe21';
    public static final String COMBINED_DOUBLE_TILDE = "\u0360";
    public static final char TILDE_FIRST_HALF = '\ufe22';
    public static final char TILDE_SECOND_HALF = '\ufe23';

    public static void removeInvalidSecondHalf(StringBuilder data) {
        FixDoubleWidth.removeInvalidSecondHalf(data, COMBINED_DOUBLE_LIGATURE, '\ufe21');
        FixDoubleWidth.removeInvalidSecondHalf(data, COMBINED_DOUBLE_TILDE, '\ufe23');
    }

    private static void removeInvalidSecondHalf(StringBuilder data, String combinedChar, char secondHalf) {
        int offset = data.indexOf(combinedChar);
        while (offset >= 0 && data.length() > offset + 2) {
            if (data.charAt(offset + 2) == secondHalf) {
                data.deleteCharAt(offset + 2);
            }
            offset = data.indexOf(combinedChar, offset + 1);
        }
    }

    public static char[] decomposeCombinedDoubleChar(char[] data) {
        for (int i = 0; i < data.length; ++i) {
            StringBuilder mod;
            if (data[i] == COMBINED_DOUBLE_LIGATURE.charAt(0)) {
                mod = new StringBuilder();
                mod.append(data);
                if (mod.length() < i + 2) {
                    mod.append(' ');
                }
                mod.setCharAt(i, '\ufe20');
                mod.insert(i + 2, '\ufe21');
                data = mod.toString().toCharArray();
                continue;
            }
            if (data[i] != COMBINED_DOUBLE_TILDE.charAt(0)) continue;
            mod = new StringBuilder();
            mod.append(data);
            if (mod.length() < i + 2) {
                mod.append(' ');
            }
            mod.setCharAt(i, '\ufe22');
            mod.insert(i + 2, '\ufe23');
            data = mod.toString().toCharArray();
        }
        return data;
    }
}

