/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.marc4j.MarcWriter;
import org.marc4j.Mrk8TranslationTable;
import org.marc4j.converter.CharConverter;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;

public class Mrk8StreamWriter
implements MarcWriter {
    private PrintWriter mrk8Writer;

    public Mrk8StreamWriter(OutputStream output) {
        try {
            this.mrk8Writer = new PrintWriter(new OutputStreamWriter(output, "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            this.mrk8Writer = new PrintWriter(output);
        }
    }

    @Override
    public void write(Record record) {
        StringBuilder recordStringBuilder = new StringBuilder();
        Leader ldr = record.getLeader();
        recordStringBuilder.append("=").append("LDR").append("  ").append(ldr.marshal()).append(System.lineSeparator());
        for (VariableField field : record.getVariableFields()) {
            recordStringBuilder.append("=").append(field.getTag()).append("  ");
            if (field instanceof ControlField) {
                ControlField controlField = (ControlField)field;
                String data = controlField.getData();
                data = data.replace(' ', '\\');
                recordStringBuilder.append(data);
            } else if (field instanceof DataField) {
                DataField dataField = (DataField)field;
                recordStringBuilder.append(dataField.getIndicator1() == ' ' ? "\\" : Character.valueOf(dataField.getIndicator1()));
                recordStringBuilder.append(dataField.getIndicator2() == ' ' ? "\\" : Character.valueOf(dataField.getIndicator2()));
                for (Subfield subField : dataField.getSubfields()) {
                    String data = Mrk8TranslationTable.toMrk8(subField.getData());
                    recordStringBuilder.append("$").append(subField.getCode()).append(data);
                }
            }
            recordStringBuilder.append(System.lineSeparator());
        }
        recordStringBuilder.append(System.lineSeparator());
        this.mrk8Writer.append(recordStringBuilder);
        this.mrk8Writer.flush();
    }

    @Override
    public void setConverter(CharConverter converter) {
    }

    @Override
    public CharConverter getConverter() {
        return null;
    }

    @Override
    public void close() {
        this.mrk8Writer.flush();
        this.mrk8Writer.close();
    }

    @Override
    public boolean expectsUnicode() {
        return true;
    }
}

