/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.marc4j.MarcException;
import org.marc4j.MarcReader;
import org.marc4j.Mrk8TranslationTable;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.AnselToUnicode;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.MarcFactory;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;

public class Mrk8StreamReader
implements MarcReader {
    private final Scanner input;
    private final MarcFactory factory;
    private boolean toUTF8;
    private String lastLineRead;
    private Pattern nonAsciiChar = Pattern.compile("[^\\u0020-\\u007F]");
    private CharConverter Marc8ToUTF8 = null;

    public Mrk8StreamReader(InputStream input) {
        this(input, false);
    }

    public Mrk8StreamReader(InputStream input, boolean toUtf8) {
        this.input = new Scanner((InputStream)new BufferedInputStream(input), StandardCharsets.UTF_8.name());
        this.factory = MarcFactory.newInstance();
        this.toUTF8 = toUtf8;
    }

    @Override
    public boolean hasNext() {
        return this.input.hasNextLine();
    }

    @Override
    public Record next() {
        ArrayList<String> lines = new ArrayList<String>();
        if (!this.hasNext()) {
            return null;
        }
        if (this.lastLineRead != null && this.lastLineRead.substring(1, 4).equalsIgnoreCase("LDR")) {
            lines.add(this.lastLineRead);
            this.lastLineRead = null;
        }
        boolean hasHiBitCharacters = false;
        while (this.input.hasNextLine()) {
            String line = this.input.nextLine();
            if (line.trim().length() == 0) continue;
            if (line.substring(1, 4).equalsIgnoreCase("LDR") && lines.size() > 0) {
                this.lastLineRead = line;
                break;
            }
            lines.add(line);
            if (hasHiBitCharacters || !this.nonAsciiChar.matcher(line).find()) continue;
            hasHiBitCharacters = true;
        }
        return this.parse(lines, hasHiBitCharacters);
    }

    protected Record parse(List<String> lines, boolean isUTF8) {
        if (lines == null || lines.isEmpty()) {
            return null;
        }
        Record record = this.factory.newRecord();
        for (String line : lines) {
            VariableField field;
            if (line.trim().length() == 0) continue;
            String tag = line.substring(1, 4);
            if (tag.equalsIgnoreCase("LDR")) {
                record.setLeader(this.getLeader(line.substring(6)));
                continue;
            }
            if (this.isControlField(tag)) {
                field = this.factory.newControlField(tag, this.unescapeFieldValue(line.substring(6)));
            } else {
                char indicator2;
                String data = line.substring(6);
                char indicator1 = data.charAt(0) == '\\' ? (char)' ' : (char)data.charAt(0);
                char c = indicator2 = data.charAt(1) == '\\' ? (char)' ' : (char)data.charAt(1);
                if (!this.isValidIndicator(indicator1) || !this.isValidIndicator(indicator2)) {
                    throw new MarcException("Wrong indicator format. It has to be a number or a space");
                }
                field = this.factory.newDataField(tag, indicator1, indicator2);
                List<String> subs = Arrays.asList(data.substring(3).split("\\$"));
                for (String sub : subs) {
                    String subData = Mrk8TranslationTable.fromMrk8(sub.substring(1));
                    if (!isUTF8 && this.toUTF8) {
                        if (this.Marc8ToUTF8 == null) {
                            this.Marc8ToUTF8 = new AnselToUnicode();
                        }
                        subData = this.Marc8ToUTF8.convert(subData);
                    }
                    Subfield subfield = this.factory.newSubfield(sub.charAt(0), subData);
                    ((DataField)field).addSubfield(subfield);
                }
            }
            record.addVariableField(field);
        }
        return record;
    }

    protected boolean isValidIndicator(char indicator) {
        return indicator == ' ' || indicator >= '0' && indicator <= '9';
    }

    protected Leader getLeader(String substring) {
        Leader leader = this.factory.newLeader();
        leader.unmarshal(substring);
        return leader;
    }

    protected String unescapeFieldValue(String fieldValue) {
        StringBuilder sb = new StringBuilder();
        for (char c : fieldValue.toCharArray()) {
            if (c == '\\') {
                sb.append(' ');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected boolean isControlField(String tag) {
        return tag.length() == 3 && tag.startsWith("00") && tag.charAt(2) >= '0' && tag.charAt(2) <= '9';
    }
}

